package eu.javaexperience.electronic.lcd.menu;

import java.util.HashMap;
import java.util.Map;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;

public class LcdSimpleMenuRegistry<L extends LcdMenu<L>> implements GetBy1<SimpleGet<L>, String>, SimplePublish2<String, SimpleGet<L>>
{
	protected Map<String, SimpleGet<L>> menuConstructors = new HashMap<>();
	
	@Override
	public SimpleGet<L> getBy(String id)
	{
		return menuConstructors.get(id);
	}

	@Override
	public void publish(String id, SimpleGet<L> constructor)
	{
		menuConstructors.put(id, constructor);
	}
}
