package eu.javaexperience.electronic.sevensegment;

public class SevenSegmentCharTools
{
	public static SevenSegmentCharacters[] transalteText(String text, SevenSegmentCharacters unknown)
	{
		SevenSegmentCharacters[] ret = new SevenSegmentCharacters[text.length()];
		text = text.toUpperCase();
		for(int i=0;i<ret.length;++i)
		{
			ret[i] = SevenSegmentCharacters.CHAR_MAP.get(text.charAt(i));
			if(null == ret[i])
			{
				ret[i] = unknown;
			}
		}
		return ret;
	}
	
	

	
	public static String[] renderChar(SevenSegmentCharacters v)
	{
		return new String[]
		{
			" "+
			//a
			(0 != (v.segmentsOn & 0b0000001)?"_":" ")+
			" ",
			
			//f
			(0 != (v.segmentsOn & 0b0100000)?"|":" ")+
			//g
			(0 != (v.segmentsOn & 0b1000000)?"_":" ")+
			//b
			(0 != (v.segmentsOn & 0b0000010)?"|":" "),
			
			//e
			(0 != (v.segmentsOn & 0b0010000)?"|":" ")+
			//d
			(0 != (v.segmentsOn & 0b0001000)?"_":" ")+
			//c
			(0 != (v.segmentsOn & 0b0000100)?"|":" ")
		};
	}
	
	public static String[] renderText(String text, SevenSegmentCharacters unknown)
	{
		StringBuilder sb1 = new StringBuilder();
		StringBuilder sb2 = new StringBuilder();
		StringBuilder sb3 = new StringBuilder();
		
		SevenSegmentCharacters[] tt = transalteText(text, unknown);
		
		for(SevenSegmentCharacters t:tt)
		{
			String[] s = renderChar(t);
			sb1.append(s[0]);
			sb2.append(s[1]);
			sb3.append(s[2]);
		}
		
		return new String[]
		{
			sb1.toString(),
			sb2.toString(),
			sb3.toString()
		};
	}
	
	public static void main(String[] args)
	{
		/*for(SevenSegmentCharacters v:SevenSegmentCharacters.values())
		{
			System.out.println(v.character);
			
			String[] ch = renderChar(v);
			System.out.println(ch[0]);
			System.out.println(ch[1]);
			System.out.println(ch[2]);
			
			System.out.println();
		}*/
		
		String[] text = renderText("Lazy fox jump over, 2020.04.28", SevenSegmentCharacters.SPACE);
		System.out.println(text[0]);
		System.out.println(text[1]);
		System.out.println(text[2]);
	}
}
