package eu.javaexperience.electronic.sevensegment;

import java.util.HashMap;
import java.util.Map;

import eu.javaexperience.collection.map.MapTools;

//look and feel: https://codegolf.stackexchange.com/questions/173837/longest-seven-segment-word
public enum SevenSegmentCharacters
{
	SPACE(' ', 0b0000000),
	EXCLAMATION('!', 0b0000010),
	DOUBLE_QUOTE('"', 0b0100010),
	HASHMARK('#', 0b0110110),
	DOLLAR('$', 0b1101001),
	PERCENTAGE('%', 0b0101101),
	AMPERSTAND('&', 0b1111011),
	SINGLE_QUOUTE('\'', 0b0100000),
	PARENTHESIS_OPEN('(', 0b0111001),
	PARENTHESIS_CLOSE(')', 0b0001111),
	START('*', 0b1100011),
	PLUS('+', 0b1110000),
	COMMA(',', 0b0001100),
	MINUS('-', 0b1000000),
	DOT('.', 0b0001100),
	SLASH('/', 0b1010010),
	BACKSLASH('\\', 0b1100100),
	COLON(':', 0b1001000),
	SEMICOLON(';', 0b1001100),
	GREATER_THAN('<', 0b1100001),
	LESS_THAN('>', 0b1000011),
	EQUALS('=', 0b1000001),
	QUESTION_MARK('?', 0b1010011),
	AT('@', 0b1011111),
	BRACKET_OPEN('(', 0b0111001),
	BRACKET_CLOSE(')', 0b0001111),
	POW('^', 0b0100011),
	UNDERSCORE('_', 0b0001000),
	
	ZERO('0', 0b0111111),
	ONE('1', 0b0000110),
	TWO('2', 0b1011011),
	THREE('3', 0b1001111),
	FOUR('4', 0b1100110),
	FIVE('5', 0b1101101),
	SIX('6', 0b1111101),
	SEVEN('7', 0b0000111),
	EIGHT('8', 0b1111111),
	NINE('9', 0b1101111),
	A('A', 0b1110111),
	B('B', 0b1111100),
	C('C', 0b0111001),
	D('D', 0b1011110),
	E('E', 0b1111001),
	F('F', 0b1110001),
	G('G', 0b0111101),
	H('H', 0b1110100),
	I('I', 0b0110000),
	J('J', 0b0011110),
	K('K', 0b1110101),
	L('L', 0b0111000),
	M('M', 0b0010101),
	N('N', 0b0110111),
	O('O', 0b0111111),
	P('P', 0b1110011),
	Q('Q', 0b1100111),
	R('R', 0b0110011),
	S('S', 0b1101101),
	T('T', 0b1111000),
	U('U', 0b0111110),
	V('V', 0b0101110),
	W('W', 0b0101010),
	X('X', 0b1110110),
	Y('Y', 0b1101110),
	Z('Z', 0b1001011)
	;
	
	private SevenSegmentCharacters(char c, int val)
	{
		this.character = c;
		this.segmentsOn = (byte) val;
	}
	
	protected final char character;
	protected final byte segmentsOn;
	
	public char getChar()
	{
		return character;
	}
	
	public byte getSegments()
	{
		return segmentsOn;
	}
	
	
	protected static Map<Character, SevenSegmentCharacters> CHAR_MAP = new HashMap<>();
	
	static
	{
		for(SevenSegmentCharacters v:SevenSegmentCharacters.values())
		{
			CHAR_MAP.put(v.character, v);
		}
	}
	
	public static SevenSegmentCharacters getByChar(char c)
	{
		return CHAR_MAP.get(c);
	}
}
