/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.display;

import eu.javaexperience.electronic.lcd.Lcd8Char;
import eu.javaexperience.electronic.lcd.display.AbstractRenderingInstruction;
import eu.javaexperience.electronic.lcd.display.CharacterDisplayState;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.text.StringTools;

public class Lcd58Rendering
extends AbstractRenderingInstruction {
    protected Lcd8Char[][] chars;
    protected int maxWidth = 0;
    public static final int TOP_LINE_Y = 0;
    public static final int BOTTOM_LINE_Y = 9;

    public Lcd58Rendering(int x0, int y0, boolean inverted, Lcd8Char[][] chars) {
        super(x0, y0, inverted);
        this.chars = chars;
        for (Lcd8Char[] c : chars) {
            int real = Lcd58Rendering.realLength(c);
            if (this.maxWidth >= real) continue;
            this.maxWidth = real;
        }
    }

    protected static int realLength(Lcd8Char[] arr) {
        int i;
        for (i = 0; i < arr.length && null != arr[i]; ++i) {
        }
        return i;
    }

    @Override
    public int getWidth() {
        return this.maxWidth * 6;
    }

    @Override
    public int getHeight() {
        return this.chars.length * 9;
    }

    @Override
    public boolean isSet(int x, int y) {
        int oX = x % 6;
        if (5 == oX) {
            return this.inverted;
        }
        int oY = y % 9;
        if (8 == oY) {
            return this.inverted;
        }
        int iY = y / 9;
        if (iY >= this.chars.length) {
            return false;
        }
        Lcd8Char[] row = this.chars[iY];
        int iX = x / 6;
        if (iX >= this.maxWidth) {
            return false;
        }
        Lcd8Char chr = row[iX];
        if (null == chr) {
            return this.inverted;
        }
        return this.inverted != (0 != (chr.getColumns()[oY] & 1 << 4 - oX));
    }

    public static Lcd58Rendering createMatrixText(int x0, int y0, boolean inverted, String text, boolean blinkShow, GetBy1<Lcd8Char, Character> getChar) {
        return new Lcd58Rendering(x0, y0, inverted, Lcd58Rendering.parseText((String)text, (boolean)blinkShow, getChar, (boolean)false, (boolean)false).screenContent);
    }

    public static CharacterDisplayState parseText(String arg0, boolean blinkShow, GetBy1<Lcd8Char, Character> getChar, boolean fillspaces, boolean inverted) {
        if (arg0.contains("\b")) {
            if (blinkShow) {
                arg0 = StringTools.replaceAllStrings((String)arg0, (String)"\b", (String)"");
            } else {
                String replace;
                int i = 0;
                while (arg0.contains("\b") && null != (replace = StringTools.getFirstBetween((String)arg0, (String)"\b", (String)"\b", null))) {
                    arg0 = StringTools.replaceAllStrings((String)arg0, (String)("\b" + replace + "\b"), (String)StringTools.repeatChar((char)' ', (int)replace.length()));
                    if (++i <= 150) continue;
                    break;
                }
            }
        }
        return CharacterDisplayState.createFromString(getChar, arg0, 16, fillspaces, inverted);
    }
}

