/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.display;

import eu.javaexperience.electronic.lcd.Lcd58Chars;
import eu.javaexperience.electronic.lcd.Lcd8Char;
import eu.javaexperience.electronic.lcd.menu.LcdDisplay;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;

public class CharacterDisplayState
implements LcdDisplayState {
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("LcdDisplayState"));
    public String rawDisplayContent;
    public Lcd8Char[][] screenContent;
    public int charactersPerLine;
    public int lines;

    public static int determineRequestedLength(String string, int charactersPerLine) {
        int ret = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\r' == c || '\n' == c) {
                if (0 != ret && 0 == ret % charactersPerLine) continue;
                ret = (ret / charactersPerLine + 1) * charactersPerLine;
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public static CharacterDisplayState createFromString(GetBy1<Lcd8Char, Character> charmap, String string, int charactersPerLine) {
        return CharacterDisplayState.createFromString(charmap, string, charactersPerLine, true);
    }

    public static CharacterDisplayState createFromString(GetBy1<Lcd8Char, Character> charmap, String string, int charactersPerLine, boolean fillSpaces) {
        CharacterDisplayState ret = new CharacterDisplayState();
        int req = CharacterDisplayState.determineRequestedLength(string, charactersPerLine);
        int lines = req / charactersPerLine;
        if (lines * charactersPerLine < req) {
            ++lines;
        }
        ret.rawDisplayContent = string;
        ret.lines = lines;
        ret.charactersPerLine = charactersPerLine;
        ret.screenContent = new Lcd8Char[lines][charactersPerLine];
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"createFromString(string: `%s`): chars %s, lines: %s, charactersPerLine: %s ", (Object[])new Object[]{string, req, lines, charactersPerLine});
        }
        int max = lines * charactersPerLine;
        int ep = 0;
        for (int i = 0; i < string.length() && ep < max; ++i) {
            char chr = string.charAt(i);
            if ('\r' == chr || '\n' == chr) {
                if (0 != ep && 0 == ep % charactersPerLine) {
                    if (!LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) continue;
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"new line, but exactly at a line end, skipping", (Object[])new Object[0]);
                    continue;
                }
                int next = (ep / charactersPerLine + 1) * charactersPerLine;
                if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"new line, filling space between %s - %s", (Object)ep, (Object)next);
                }
                if (fillSpaces) {
                    ret.fillBetween(ep, next, Lcd58Chars.Lcd58AsciiChars.SPACE);
                }
                ep = next;
                continue;
            }
            Lcd8Char dc = (Lcd8Char)charmap.getBy((Object)Character.valueOf(chr));
            if (null == dc) continue;
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"placing char `%s` (`%s`) to line %s, to row %s", (Object[])new Object[]{dc, Character.valueOf(dc.getChar()), ep / charactersPerLine, ep % charactersPerLine});
            }
            ret.screenContent[ep / charactersPerLine][ep % charactersPerLine] = dc;
            ++ep;
        }
        return ret;
    }

    public void fillBetween(int from, int toExcluded, Lcd58Chars.Lcd58AsciiChars character) {
        for (int ep = from; ep < toExcluded; ++ep) {
            this.screenContent[ep / this.charactersPerLine][ep % this.charactersPerLine] = character;
        }
    }

    public String getRaw() {
        return null == this.rawDisplayContent ? "" : this.rawDisplayContent;
    }

    @Override
    public void render(LcdDisplay display) {
    }
}

