/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.electronic.lcd.display;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.electronic.lcd.display.RenderingInstruction;
import eu.javaexperience.electronic.lcd.menu.LcdDisplay;
import eu.javaexperience.electronic.lcd.menu.LcdDisplayState;
import java.util.ArrayList;
import java.util.List;

public class MatrixRenderInstructions
implements LcdDisplayState {
    protected List<RenderingInstruction> instructions = new ArrayList<RenderingInstruction>();

    public List<RenderingInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public void render(LcdDisplay display) {
        for (RenderingInstruction i : this.instructions) {
            int x0 = i.getX0();
            int y0 = i.getY0();
            int height = i.getHeight();
            int width = i.getWidth();
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    if (!i.isSet(w, h)) continue;
                    display.setPixel(x0 + w, y0 + h);
                }
            }
        }
    }

    public MatrixRenderInstructions(RenderingInstruction ... instr) {
        CollectionTools.inlineAdd(this.instructions, (Object[])instr);
    }

    public static MatrixRenderInstructions instructions(RenderingInstruction ... instr) {
        return new MatrixRenderInstructions(instr);
    }
}

