package eu.javaexperience.classes.dinamic;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.interfaces.ObjectWithProperty;

public class DinamicClassField implements ClassFieldDescriptor, ObjectWithProperty
{
	protected DinamicClassSpace classSpace;
	
	//will be set up by eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassDescriptor.createClass or in constructor
	protected ClassDescriptor ownerClass;
	protected ClassAnnotationDescriptor[] attrs;
	protected boolean isUserAccessible;
	protected String translation;
	protected String name;
	
	protected String strType;
	protected ClassDescriptor type;
	protected int modifiers;
	
	@Override
	public ClassDescriptor getOwnerModel()
	{
		return ownerClass;
	}

	/*@Override
	public FieldExtraAttributes getExtraAttributes()
	{
		return attrs;
	}*/

	@Override
	public boolean isUserAccessible()
	{
		return isUserAccessible;
	}

	@Override
	public String getTranslationSymbol()
	{
		return translation;
	}

	@Override
	public String getName()
	{
		return name;
	}

	@Override
	public ClassDescriptor getType()
	{
		if(null == type)
		{
			type = classSpace.getClassByName(strType);
		}
		return type;
	}
	
	@Override
	public String toString()
	{
		return "DinamicClassField: "+getOwnerModel().getClassName()+"."+name;
	}
	
	public static DinamicClassField create
	(
		int modifiers,
		ClassDescriptor type,
		String name,
		String translationSymbol,
		boolean userAccessible,
		ClassAnnotationDescriptor[] attr
	)
	{
		DinamicClassField ret = new DinamicClassField();
		ret.name = name;
		ret.translation = translationSymbol;
		ret.isUserAccessible = userAccessible;
		ret.type = type;
		ret.attrs = attr;
		return ret;
	}
	
	public static DinamicClassField create
	(
		int modifiers,
		DinamicClassSpace cs,
		String strType,
		String name,
		String translationSymbol,
		boolean userAccessible,
		ClassAnnotationDescriptor[] attr
	)
	{
		DinamicClassField ret = new DinamicClassField();
		ret.classSpace = cs;
		ret.name = name;
		ret.translation = translationSymbol;
		ret.isUserAccessible = userAccessible;
		ret.strType = strType;
		ret.attrs = attr;
		return ret;
	}

	@Override
	public int getModifiers()
	{
		return modifiers;
	}

	@Override
	public Object get(String key)
	{
		return ClassDescriptorTools.fieldPropGet(this, key);
	}

	@Override
	public String[] keys()
	{
		return ClassDescriptorTools.fieldPropKeys();
	}

	@Override
	public ClassAnnotationDescriptor[] getAnnotations() {
		return null;
	}
}
