package eu.javaexperience.classes.java;

import eu.javaexperience.query.F;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStorageTools;
import hu.ddsi.java.database.GenericStoreException;
import eu.javaexperience.query.LogicalGroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.gsdbrpc.SynchronServerModelAccess;
import eu.javaexperience.gsdbrpc.RpcDbModel;
import eu.javaexperience.gsdbrpc.api.ModelManager;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;

public class JavaModelManager<M extends RpcDbModel> implements ModelManager<M>
{
	protected SynchronServerModelAccess db;
	
	public JavaModelManager(SynchronServerModelAccess db)
	{
		this.db = db;
	}
	
	protected static Class extractClass(ClassDescriptor cd)
	{
		if(cd instanceof JavaClassDescriptor)
		{
			return ((JavaClassDescriptor) cd).cls;
		}
		
		throw new RuntimeException("JavaModelManager can work only with JavaClassDescriptor");
	}
	
	@Override
	public <B extends M> B getById(ClassDescriptor cls, long id) throws Throwable
	{
		return (B) GenericStorageTools.getSingle(extractClass(cls), F.eq.is("do", id), db.getRemoteDatabase());
	}

	@Override
	public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> update(ClassDescriptor cls, DataObject obj)
	{
		return null;
	}

	@Override
	public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> create(ClassDescriptor cls, DataObject obj)
	{
		return null;
	}

	@Override
	public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> delete(ClassDescriptor cls, long id, DataObject deleteInstruction)
	{
		return null;
	}

	@Override
	public <B extends M> B createModel(ClassDescriptor cls) throws Exception
	{
		B ret = (B) extractClass(cls).newInstance();
		db.setOwnerDatabase(ret);
		
		return ret;
	}

	@Override
	public <B extends M> List<B> select(ClassDescriptor cls, LogicalGroup criteria)
	{
		ArrayList<B> coll = new ArrayList<>();
		try
		{
			GenericStorage.getAllObjectsByQuery(extractClass(cls), criteria, coll, db.getRemoteDatabase());
		}
		catch (GenericStoreException e)
		{
			Mirror.propagateAnyway(e);
		}
		return coll;
	}

	protected List<ClassDescriptor> managedModels;
	
	@Override
	public List<ClassDescriptor> getManagedModels()
	{
		if(null != managedModels)
		{
			String[] mods = db.getApi().getManagedModels();
			List<ClassDescriptor> cd = new ArrayList<>();
			
			for(String mod:mods)
			{
				try
				{
					cd.add(JavaClassDescriptor.getOfJavaClass(Class.forName(mod)));
				}
				catch (ClassNotFoundException e)
				{
					e.printStackTrace();
				}
			}
			
			managedModels = (List<ClassDescriptor>) Collections.unmodifiableCollection(cd);
		}
		return managedModels;
	}

	@Override
	public Set<String> getPermissions()
	{
		return db.getPermissions();
	}
}
