/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.classes.dinamic;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassSpace;
import eu.javaexperience.classes.dinamic.DinamicClassDescriptor;
import eu.javaexperience.classes.dinamic.DinamicClassSpace;
import eu.javaexperience.classes.java.JavaClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassSpaceTools {
    protected static Pattern ONE_LEVEL_ARRAY = Pattern.compile("^\\[L(.*);$");
    protected static Pattern MULTI_LEVEL_ARRAY = Pattern.compile("^\\[(.*)$");

    public static void injectJavaTypes(DinamicClassSpace cs, Class ... clss) {
        for (Class cls : clss) {
            cs.registerClass(cls.getName(), JavaClassDescriptor.getOfJavaClass(cls));
        }
    }

    public static void injectBasicJavaClasses(DinamicClassSpace cs) {
        ClassSpaceTools.injectJavaTypes(cs, Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class, String.class, Date.class);
    }

    public static <CS extends ClassSpace> DinamicClassSpace createUsualClassSpace(GetBy2<ClassDescriptor, CS, String> classLoader) {
        DinamicClassSpace ret = ClassSpaceTools.createMinimalClassSpace(classLoader);
        ClassSpaceTools.injectBasicJavaClasses(ret);
        return ret;
    }

    public static <CS extends ClassSpace> DinamicClassSpace createMinimalClassSpace(GetBy2<ClassDescriptor, CS, String> classLoader) {
        DinamicClassSpace[] ptr;
        GetBy2 fetch = ClassSpaceTools.addArrayFetch(classLoader);
        DinamicClassSpace ret = new DinamicClassSpace((GetBy1<ClassDescriptor, String>)((GetBy1)a -> (ClassDescriptor)fetch.getBy((Object)ptr[0], a)));
        ptr = new DinamicClassSpace[]{ret};
        return ret;
    }

    public static DinamicClassSpace createStandaloneClassSpaceWithArraySupport(@MayNull DataArray classDescriptors) {
        DinamicClassSpace ret = new DinamicClassSpace(ClassSpaceTools.addArrayFetch(null));
        if (null != ret) {
            for (int i = 0; i < classDescriptors.size(); ++i) {
                ret.parseDescriptor(classDescriptors.getObject(i));
            }
        }
        return ret;
    }

    public static GetBy2<ClassDescriptor, ClassSpace, String> createJavaNativeClassLoader(final GetBy1<ClassDescriptor, Class> wrapper) {
        return new GetBy2<ClassDescriptor, ClassSpace, String>(){

            public ClassDescriptor getBy(ClassSpace a, String b) {
                try {
                    return (ClassDescriptor)wrapper.getBy(Class.forName(b));
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        };
    }

    public static <C extends ClassDescriptor, CS extends ClassSpace> GetBy2<C, CS, String> addArrayFetch(final GetBy2<C, CS, String> classLoader) {
        return new GetBy2<C, CS, String>(){

            public C getBy(CS cs, String a) {
                Matcher m = ONE_LEVEL_ARRAY.matcher(a);
                if (m.find()) {
                    ClassDescriptor cd = cs.getClassByName(m.group(1));
                    if (null == cd) {
                        return null;
                    }
                    return DinamicClassDescriptor.createArrayType(cd);
                }
                m = MULTI_LEVEL_ARRAY.matcher(a);
                if (m.find()) {
                    ClassDescriptor cd = cs.getClassByName(m.group(1));
                    if (null == cd) {
                        return null;
                    }
                    return DinamicClassDescriptor.createArrayType(cd);
                }
                return (ClassDescriptor)classLoader.getBy(cs, (Object)a);
            }
        };
    }
}

