package eu.javaexperience.classes.dinamic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassSpace;
import eu.javaexperience.classes.java.JavaClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;

public class ClassSpaceTools
{
	public static void injectJavaTypes(DinamicClassSpace cs, Class... clss)
	{
		for(Class cls :clss)
		{
			cs.registerClass(cls.getName(), JavaClassDescriptor.getOfJavaClass(cls));
		}
	}
	
	public static void injectBasicJavaClasses(DinamicClassSpace cs)
	{
		injectJavaTypes
		(
			cs,
			void.class,
			Void.class,
			boolean.class,
			Boolean.class,
			byte.class,
			Byte.class,
			char.class,
			Character.class,
			short.class,
			Short.class,
			int.class,
			Integer.class,
			long.class,
			Long.class,
			float.class,
			Float.class,
			double.class,
			Double.class,
			
			BigDecimal.class,
			BigInteger.class,
			
			String.class,
			
			Date.class
		);
	}
	
	/**
	 * Creates a ClassSpace with:
	 * 	- array type fetch mechanism (fetches type automatically: "[LMyType;" => MyType[]) 
	 * 	- basic java classes void-Void-boolean-...-int-...-double-...-BigDecimal-...-String-Date
	 * 	- classLoader callback
	 * */
	public static <CS extends ClassSpace> DinamicClassSpace createUsualClassSpace(GetBy2<ClassDescriptor, CS, String> classLoader)
	{
		DinamicClassSpace ret = createMinimalClassSpace(classLoader);
		injectBasicJavaClasses(ret);
		return ret;
	}
	
	/**
	 * Creates a ClassSpace with:
	 * 	- array type fetch mechanism (fetches type automatically: "[LMyType;" => MyType[]) 
	 * 	- classLoader callback
	 * */
	public static <C extends ClassDescriptor, CS extends ClassSpace> DinamicClassSpace createMinimalClassSpace(GetBy2<C, CS, String> classLoader)
	{
		return new DinamicClassSpace((GetBy2)addArrayFetch(classLoader));
	}
	
	public static DinamicClassSpace createStandaloneClassSpaceWithArraySupport(@MayNull DataArray classDescriptors)
	{
		DinamicClassSpace ret = new DinamicClassSpace(addArrayFetch(null));
		if(null != ret)
		{
			for(int i=0;i<classDescriptors.size();++i)
			{
				ret.parseDescriptor(classDescriptors.getObject(i));
			}
		}
		return ret;
	}
	
	public static GetBy2<ClassDescriptor, ClassSpace, String> createJavaNativeClassLoader(GetBy1<ClassDescriptor, Class> wrapper)
	{
		return new GetBy2<ClassDescriptor, ClassSpace, String>()
		{
			@Override
			public ClassDescriptor getBy(ClassSpace a, String b)
			{
				try
				{
					return wrapper.getBy(Class.forName(b));
				}
				catch(Exception e)
				{
					Mirror.propagateAnyway(e);
					return null;
				}
			}
		};
	}
	
	protected static Pattern ONE_LEVEL_ARRAY = Pattern.compile("^\\[L(.*);$");
	protected static Pattern MULTI_LEVEL_ARRAY = Pattern.compile("^\\[(.*)$");
	
	public static <C extends ClassDescriptor, CS extends ClassSpace> GetBy2<C, CS, String> addArrayFetch(GetBy2<C, CS, String> classLoader)
	{
		return new GetBy2<C, CS, String>()
		{
			@Override
			public C getBy(CS cs, String a)
			{
				{
					Matcher m = ONE_LEVEL_ARRAY.matcher(a);
					if(m.find())
					{
						C cd = (C) cs.getClassByName(m.group(1));
						if(null == cd)
						{
							return null;
						}
						return (C) DinamicClassDescriptor.createArrayType(cd);
					}
				}
				{
					Matcher m = MULTI_LEVEL_ARRAY.matcher(a);
					if(m.find())
					{
						ClassDescriptor cd = cs.getClassByName(m.group(1));
						if(null == cd)
						{
							return null;
						}
						return (C) DinamicClassDescriptor.createArrayType(cd);
					}
				}
				
				return classLoader.getBy(cs, a);
			}
		};
	}
}
