package eu.javaexperience.gsdbrpc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.MirrorFunctions;
import eu.javaexperience.reflect.Mirror.ClassData;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.query.F;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GsdbExtraCaluse;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.query.LogicalRelation;

public class RemoteGsdbTools
{
	public static AtomicCondition parseAtomicCondition(DataObject ac)
	{
		F op = F.valueOf(ac.getString("o").toLowerCase());
		boolean neg = ac.getBoolean("n");
		String f = ac.getString("f");
		Object val = ac.opt("v");
		if(val instanceof DataArray)
		{
			val = ((DataArray)val).asJavaArray();
		}
		
		return new AtomicCondition(op, neg, f, val);
	}
	
	public static LogicalGroup parseCriteria(DataObject criteria)
	{
		String relation = criteria.optString("r");
		DataObject atomicCondidition = criteria.optObject("a");
		DataArray comp = criteria.optArray("c");
		
		if(null == relation)//maybe an atomic condition already
		{
			return new LogicalGroup(parseAtomicCondition(criteria));
		}
		else if(null != atomicCondidition)
		{
			return new LogicalGroup(parseAtomicCondition(atomicCondidition));
		}
		else
		{
			LogicalGroup[] lrs = new LogicalGroup[comp.size()];
			for(int i=0;i<lrs.length;++i)
			{
				lrs[i] = parseCriteria(comp.getObject(i));
			}
			
			return new LogicalGroup(LogicalRelation.valueOf(relation.toLowerCase()), lrs);
		}		
	}
	
	public static DataObject serialize(AtomicCondition ac, DataCommon proto)
	{
		DataObject ret = proto.newObjectInstance();
		
		ret.putString("o", ac.getOperator().name());
		ret.putBoolean("n", ac.isNegated());
		ret.putString("f", ac.getFieldName());
		DataReprezTools.put(ret, "v", ac.getValue());
		
		return ret;
	}
	
	public static DataObject serialize(LogicalGroup lg, DataCommon proto)
	{
		DataObject ret = proto.newObjectInstance();
		
		ret.putString("r", lg.getLogicalRelation().name());
		AtomicCondition ac = lg.getAtomicCondition();
		if(null != ac)
		{
			ret.putObject("a", serialize(ac, proto));
		}
		
		LogicalGroup[] g = lg.getLogicalGroups();
		if(null != g)
		{
			DataArray add = proto.newArrayInstance();
			for(int i=0;i<g.length;++i)
			{
				add.putObject(serialize(g[i], proto));
			}
			ret.putArray("c", add);
		}
		
		return ret;
	}
	
	public static class GsdbExtraClauseWrapper implements ObjectWithProperty
	{ 
		protected GsdbExtraCaluse clause;

		public GsdbExtraClauseWrapper(GsdbExtraCaluse c)
		{
			this.clause = c;
		}

		@Override
		public Object get(String key)
		{
			return getManager().get(clause, key);
		}
		
		protected static Map<Class, ObjectWithPropertyStorage<GsdbExtraCaluse>> CLS_PROP = new HashMap<>();
		
		protected ObjectWithPropertyStorage<GsdbExtraCaluse> getManager()
		{
			ObjectWithPropertyStorage<GsdbExtraCaluse> ret = CLS_PROP.get(clause.getClass());
			if(null == ret)
			{
				ret = new ObjectWithPropertyStorage<GsdbExtraCaluse>();
				ret.addExaminer("type", (e)->e.getType().name());
				ClassData cds = Mirror.getClassData(clause.getClass());
				for(final Field f:cds.select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD))
				{
					ret.addExaminer(f.getName(), (GetBy1) MirrorFunctions.createGetter(f));
				}
			}
			
			return ret;
		}
		
		@Override
		public String[] keys()
		{
			return getManager().keys();
		}
	}
	
	public static DataArray serialize
	(
		GsdbExtraCaluse[] extraClause,
		DataCommon instance
	)
	{
		DataArray ret = instance.newArrayInstance();
		if(null != ret)
		{
			for(int i=0;i<extraClause.length;++i)
			{
				GsdbExtraCaluse c = extraClause[i];
				if(null != c)
				{
					ret.putObject(instance.fromObjectLike(new GsdbExtraClauseWrapper(c)));
				}
			}
		}
		
		return ret;
	}
	
	public static boolean isWebgsdbUseField(Field f)
	{
		return Modifier.isPublic(f.getModifiers());
	}
	
	public static <T extends RpcDbModel> ValidationResult<TranslationFriendlyValidationEntry> createNewFrom
	(
		GenericStoreDatabase gdb,
		Class<T> cls,
		DataObject data
	)
		throws Exception
	{
		T modify = (T) cls.newInstance();
		GenericStoreData gd = GenericStorage.getOrCreateGenericStoreData(modify);
		//set the owner on order to can load object reference ids
		gd.setOwnerDatabase(gdb);
		modify.loadFromUser(data);
		
		ValidationResult<TranslationFriendlyValidationEntry> ret = new ValidationResult<>();
		ret.valid = modify.validate(ret.reportEntries);
		
		if(ret.valid)
		{
			GenericStorage.post(gdb, modify);
		}
		
		return ret;
	}
	
	public static ValidationResult<TranslationFriendlyValidationEntry> delete
	(
		GenericStoreDatabase userDatabase,
		Class<? extends RpcDbModel> cls,
		long id,
		DataObject deleteInstruction
	)
		throws GenericStoreException
	{
		RpcDbModel elem = GenericStorage.getObjectByIDDescendantOf(id, cls, userDatabase);
		
		ValidationResult<TranslationFriendlyValidationEntry> ret = new ValidationResult<>();
		
		if(null == elem)
		{
			ret.valid = false;
			ret.reportEntries.add
			(
				new TranslationFriendlyValidationEntry
				(
					"id",
					"db_object_by_id_not_found",
					new OneShotMap<String, String>("id", String.valueOf(id))
				)
			);
			return ret;
		}
		
		ret.valid = elem.delete(ret.reportEntries);
		
		if(ret.valid)
		{
			GenericStorage.removeObject(elem, userDatabase);
		}
		
		return ret;
	}
	
	public static DataObject operation
	(
		GenericStoreDatabase userDatabase,
		Class<? extends RpcDbModel> cls,
		long id,
		String operation,
		DataObject instructions
	)
		throws GenericStoreException
	{
		RpcDbModel elem = GenericStorage.getObjectByIDDescendantOf(id, cls, userDatabase);
		
		if(null == elem)
		{
			throw new RuntimeException("Object not found "+cls.getSimpleName()+"("+id+")");
		}
		
		return elem.operation(operation, instructions);
	}
	
	public static <T extends RpcDbModel> ValidationResult<TranslationFriendlyValidationEntry> tryUpdateFrom
	(
		GenericStoreDatabase gdb,
		Class<T> cls,
		long id,
		DataObject data,
		String err_idNotExtist
	)
		throws GenericStoreException
	{
		T elem = GenericStorage.getObjectByIDDescendantOf(id, cls, gdb);
		if(null == elem)
		{
			throw new RuntimeException(err_idNotExtist);
		}
		
		//az ID-t leszámítva mindent updatelünk
		
		ValidationResult<TranslationFriendlyValidationEntry> ret = new ValidationResult<>();
		{
			T modify = (T) elem.clone();		
			modify.loadFromUser(data);
			ret.valid = modify.validate(ret.reportEntries);
		}
		
		if(ret.valid)
		{
			elem.loadFromUser(data);
			GenericStorage.update(elem);
		}
		
		return ret;
	}
}
