/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.gsdbrpc;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.gsdbrpc.GenericModelManagementApi;
import eu.javaexperience.gsdbrpc.ModelManagementApi;
import eu.javaexperience.gsdbrpc.MultiDbModelManagementApi;
import eu.javaexperience.gsdbrpc.RpcDbModel;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import java.util.List;
import java.util.Set;

public abstract class ProxyGenericModelManagementApi
implements MultiDbModelManagementApi {
    protected String sessionKey;

    public ProxyGenericModelManagementApi(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    protected void setRpcSessionDatabaseSelection(String sel) {
        RpcSessionTools.ensureGetCurrentRpcSession().getExtraDataMap().put(this.sessionKey, sel);
    }

    protected String getRpcSessionDatabaseSelection() {
        return (String)RpcSessionTools.ensureGetCurrentRpcSession().getExtraDataMap().get(this.sessionKey);
    }

    protected abstract ModelManagementApi getDbByName(String var1);

    protected ModelManagementApi getDatabase() {
        String currentDb = this.getRpcSessionDatabaseSelection();
        if (null == currentDb) {
            throw new RuntimeException("No database selected");
        }
        return this.getDbByName(currentDb);
    }

    @Override
    public void selectDatabase(String db) {
        List<String> available = this.listDatabases();
        if (!available.contains(db)) {
            throw new RuntimeException("Database `" + db + "` doesn't exists.");
        }
        this.setRpcSessionDatabaseSelection(db);
    }

    @Override
    public String getSelectedDatabase() {
        return this.getRpcSessionDatabaseSelection();
    }

    @Override
    public String[] getManagedModels() {
        return this.getDatabase().getManagedModels();
    }

    @Override
    public GenericModelManagementApi.ModelMetadata getModelMetadata(String cls) throws Exception {
        return this.getDatabase().getModelMetadata(cls);
    }

    @Override
    public List<ClassDescriptor> getAllAccessableClass() {
        return this.getDatabase().getAllAccessableClass();
    }

    @Override
    public RpcDbModel getById(String cls, long id) throws Throwable {
        return this.getDatabase().getById(cls, id);
    }

    @Override
    public List<RpcDbModel> select(String cls, DataObject criteria, DataArray selectionExtra) throws Exception {
        return this.getDatabase().select(cls, criteria, selectionExtra);
    }

    @Override
    public ValidationResult<TranslationFriendlyValidationEntry> update(String cls, DataObject obj) throws Exception {
        return this.getDatabase().update(cls, obj);
    }

    @Override
    public ValidationResult<TranslationFriendlyValidationEntry> create(String cls, DataObject obj) throws Exception {
        return this.getDatabase().create(cls, obj);
    }

    @Override
    public ValidationResult<TranslationFriendlyValidationEntry> delete(String cls, long id, DataObject deleteInstruction) throws Exception {
        return this.getDatabase().delete(cls, id, deleteInstruction);
    }

    @Override
    public Set<String> getPermissions() {
        return this.getDatabase().getPermissions();
    }

    @Override
    public void fork(String name) {
        throw new RuntimeException("Fork not supported");
    }
}

