package eu.javaexperience.gsdbrpc.api;

import eu.javaexperience.query.LogicalGroup;

import java.util.List;
import java.util.Set;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.gsdbrpc.RpcDbModel;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;

public interface ModelManager<M extends RpcDbModel>
{
	public <B extends M> B getById(ClassDescriptor cls, long id) throws Throwable;
	public <B extends M> ValidationResult<TranslationFriendlyValidationEntry> update(ClassDescriptor cls, DataObject obj);
	public <B extends M> ValidationResult<TranslationFriendlyValidationEntry> create(ClassDescriptor cls, DataObject obj);
	
	//TODO limit offset, order
	public <B extends M> List<B> select(ClassDescriptor cls, LogicalGroup criteria);
	public <B extends M> ValidationResult<TranslationFriendlyValidationEntry> delete(ClassDescriptor cls, long id, DataObject deleteInstruction);
	public List<ClassDescriptor> getManagedModels();
	
	public <B extends M> B createModel(ClassDescriptor cls) throws Exception;
	
	public DataObject operation(String cls, long id, String operation, DataObject instructions);
	
	public Set<String> getPermissions();
}
