package eu.javaexperience.classes.dinamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;

public class DinamicClassAnnotation implements ClassAnnotationDescriptor
{
	public static final DinamicClassAnnotation[] emptyDinamicClassAnnotationArray = new DinamicClassAnnotation[0];
	
	protected String type;
	protected Map<String, Object> data = new SmallMap<>();
	
	public DinamicClassAnnotation(String type)
	{
		this.type = type;
	}
	
	protected Map<String, Object> extraData;
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}
	
	@Override
	public String getType()
	{
		return type;
	}
	
	@Override
	public Map<String, Object> getAnnotationData()
	{
		return data;
	}
	
	public static DinamicClassAnnotation parse(DataObject annotation)
	{
		if(annotation.has("type"))
		{
			DinamicClassAnnotation ret = new DinamicClassAnnotation(annotation.getString("type"));
			if(annotation.has("data"))
			{
				DataObject obj = annotation.getObject("data");
				for(String k:obj.keys())
				{
					ret.data.put(k, obj.get(k));
				}
			}
			
			return ret;
		}
		return null;
	}
	
	public static DinamicClassAnnotation[] parse(DataArray annotations)
	{
		List<DinamicClassAnnotation> ret = new ArrayList<>();
		for(int i=0;i<annotations.size();++i)
		{
			DinamicClassAnnotation add = parse(annotations.getObject(i));
			if(null != add)
			{
				ret.add(add);
			}
		}
		
		return ret.toArray(DinamicClassAnnotation.emptyDinamicClassAnnotationArray);
	}
}
