package eu.javaexperience.classes.java;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.gsdbrpc.RemoteGsdbTools;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;

public class JavaClassField implements ClassFieldDescriptor, ObjectWithProperty
{
	protected FieldData fd;
	protected Field f;
	
	/*@Override
	public FieldExtraAttributes getExtraAttributes()
	{
		return null == fd?null:WebGsdbTools.tryGetModelFieldExtraAttributes(fd);
	}*/

	@Override
	public String getTranslationSymbol()
	{
		return null == fd?null:getTranslationName(fd);
	}
	
	protected static String getTranslationName(FieldData fd)
	{
		String text = fd.getField().getName();
	/*	FieldExtraAttributes data = WebGsdbTools.tryGetModelFieldExtraAttributes(fd);
		if(null != data)
		{
			text = data.transaltionLabel;
		} TODO
	*/
		return text;
	}
	
	@Override
	public String getName()
	{
		return f.getName();
	}

	@Override
	public boolean isUserAccessible()
	{
		return null == fd?false:RemoteGsdbTools.isWebgsdbUseField(fd.f);
	}

	protected ClassDescriptor ownerClass;
	@Override
	public ClassDescriptor getOwnerModel()
	{
		if(null == ownerClass)
		{
			ownerClass = JavaClassDescriptor.getOfJavaClass(f.getDeclaringClass());
		}
		return ownerClass;
	}

	protected ClassDescriptor type;
	
	@Override
	public ClassDescriptor getType()
	{
		if(null == type)
		{
			type = JavaClassDescriptor.getOfJavaClass(f.getType());
		}
		return type;
	}
	
	protected static final ConcurrentMap<Field, JavaClassField> FIELD_DESCRIPTORS = new ConcurrentHashMap<Field, JavaClassField>();
	
	protected static final GetBy1<JavaClassField, Field> WRAP_FIELD = new GetBy1<JavaClassField, Field>()
	{
		@Override
		public JavaClassField getBy(Field a)
		{
			JavaClassField ret = new JavaClassField();
			ret.f = a;
			if(GenericStorable.class.isAssignableFrom(a.getDeclaringClass()))
			{
				FieldData[] cd = GenericStorage.getOrCollectClassDataRt((Class<GenericStorable>) a.getDeclaringClass());
				ret.fd = GenericStorage.getFieldByName(cd, a.getName());
			}
			ret.init();
			return ret;
		}
	}; 
	
	protected static JavaClassField getOfJavaField(Field f)
	{
		return MapTools.getOrCreate(FIELD_DESCRIPTORS, f, WRAP_FIELD);
	}

	public static List<JavaClassField> wrapAll(Field[] declaredFields)
	{
		List<JavaClassField> ret = new ArrayList<>();
		for(Field f:declaredFields)
		{
			ret.add(getOfJavaField(f));
		}
		
		return Collections.unmodifiableList(ret);
	}

	@Override
	public int getModifiers()
	{
		return f.getModifiers();
	}
	
	@Override
	public Object get(String key)
	{
		return ClassDescriptorTools.fieldPropGet(this, key);
	}

	@Override
	public String[] keys()
	{
		return ClassDescriptorTools.fieldPropKeys();
	}

	public Field getJavaField()
	{
		return f;
	}
	
	protected List<ClassAnnotationDescriptor> annotations;
	
	protected void init()
	{
		annotations = JavaClassAnnotationDescriptor.parse(f.getAnnotations());
	}

	@Override
	public List<ClassAnnotationDescriptor> getAnnotations()
	{
		return annotations;
	}
}
