package eu.javaexperience.classes.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;

public class JavaClassAnnotationDescriptor implements ClassAnnotationDescriptor, ObjectWithProperty
{
	protected transient Map<String, Object> extraData;
	
	protected String type;
	protected Map<String,Object> data;
	
	protected JavaClassAnnotationDescriptor(){}
	
	public JavaClassAnnotationDescriptor(String type)
	{
		this.type = type;
		this.data = new SmallMap<>();
	}
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}

	@Override
	public String getType()
	{
		return type;
	}
	
	public Map<String, Object> getAnnotationData()
	{
		return data;
	}
	
	protected static ObjectWithPropertyStorage<JavaClassAnnotationDescriptor> PROPS = new ObjectWithPropertyStorage<>();
	
	static
	{
		PROPS.addExaminer("type", (e)->e.type);
		PROPS.addExaminer("data", (e)->e.data);
	}

	@Override
	public Object get(String key)
	{
		return PROPS.get(this, key);
	}

	@Override
	public String[] keys()
	{
		return PROPS.keys();
	}
	
	public static JavaClassAnnotationDescriptor parse(Annotation ann)
	{
		JavaClassAnnotationDescriptor ret = new JavaClassAnnotationDescriptor();
		Class<? extends Annotation> t = ann.annotationType();
		ret.type = t.getCanonicalName();
		
		Map<String, Object> data = new SmallMap<>();
		for(Method m:t.getMethods())
		{
			try
			{
				if(0 == m.getParameterCount())
				{
					String name = m.getName();
					if
					(
							"hashCode".equals(name)
						||
							"toString".equals(name)
						||
							"annotationType".equals(name)
					)
					{
						continue;
					}
					
					Object add = m.invoke(ann);
					if(null != add && !PrimitiveTools.isPrimitiveClass(add.getClass()) && !(add instanceof String))
					{
						if(add instanceof Annotation)
						{
							add = parse((Annotation) add);
						}
						else if(add instanceof Annotation[])
						{
							add = parse((Annotation[]) add);
						}
						else
						{
							add = null;
						}
					}
					
					if(null != add)
					{
						data.put(name, add);
					}
				}
			}
			catch (Exception e)
			{
				Mirror.propagateAnyway(e);
			}
		}
		
		ret.data = Collections.unmodifiableMap(data);
		return ret;
	}
	
	
	public static List<ClassAnnotationDescriptor> parse(Annotation[] annotations)
	{
		if(null == annotations)
		{
			return NullList.instance;
		}
		
		List<ClassAnnotationDescriptor> ret = new ArrayList<>();
		for(int i=0;i<annotations.length;++i)
		{
			ret.add(parse(annotations[i]));
		}
		return ret;
	}
}
