package eu.javaexperience.gsdbrpc;

import java.util.List;
import java.util.Set;

import eu.javaexperience.interfaces.simple.SimpleGet;
import hu.ddsi.java.database.GenericStoreDatabase;

public abstract class MultiDbGenericModelManagementApi extends GenericModelManagementApi
{
	public MultiDbGenericModelManagementApi(SimpleGet<Set<String>> permissions, Class<? extends RpcDbModel>... classes)
	{
		super(null, permissions, classes);
		this.srcGdb = new SimpleGet<GenericStoreDatabase>()
		{
			@Override
			public GenericStoreDatabase get()
			{
				return getDatabase();
			}
		};
	}
	
	public MultiDbGenericModelManagementApi()
	{
		this(null);
	}
	
	protected String currentDb;
	
	protected abstract GenericStoreDatabase getDbByName(String db);
	
	public GenericStoreDatabase getDatabase()
	{
		if(null == currentDb)
		{
			throw new RuntimeException("No database selected");
		}
		
		return getDbByName(currentDb);
	}
	
	public abstract List<String> listDatabases();
	
	public void selectDatabase(String db)
	{
		List<String> available = listDatabases();
		if(!available.contains(db))
		{
			throw new RuntimeException("Database `"+db+"` doesn't exists.");
		}
		currentDb = db;
	}
	
	public String getSelectedDatabase()
	{
		return currentDb;
	}
}