/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.classes.java;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JavaClassAnnotationDescriptor
implements ClassAnnotationDescriptor,
ObjectWithProperty {
    protected transient Map<String, Object> extraData;
    protected String type;
    protected Map<String, Object> data;
    protected static ObjectWithPropertyStorage<JavaClassAnnotationDescriptor> PROPS = new ObjectWithPropertyStorage();

    protected JavaClassAnnotationDescriptor() {
    }

    public JavaClassAnnotationDescriptor(String type) {
        this.type = type;
        this.data = new SmallMap();
    }

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap();
        }
        return this.extraData;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getAnnotationData() {
        return this.data;
    }

    public Object get(String key) {
        return PROPS.get((Object)this, key);
    }

    public String[] keys() {
        return PROPS.keys();
    }

    public static JavaClassAnnotationDescriptor parse(Annotation ann) {
        JavaClassAnnotationDescriptor ret = new JavaClassAnnotationDescriptor();
        Class<? extends Annotation> t = ann.annotationType();
        ret.type = t.getCanonicalName();
        SmallMap data = new SmallMap();
        for (Method m : t.getMethods()) {
            try {
                String name;
                if (0 != m.getParameterCount() || "hashCode".equals(name = m.getName()) || "toString".equals(name) || "annotationType".equals(name)) continue;
                List<ClassAnnotationDescriptor> add = m.invoke((Object)ann, new Object[0]);
                if (null != add && !PrimitiveTools.isPrimitiveClass(add.getClass()) && !(add instanceof String)) {
                    add = add instanceof Annotation ? JavaClassAnnotationDescriptor.parse((Annotation)((Object)add)) : (add instanceof Annotation[] ? JavaClassAnnotationDescriptor.parse((Annotation[])add) : null);
                }
                if (null == add) continue;
                data.put(name, add);
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        ret.data = Collections.unmodifiableMap(data);
        return ret;
    }

    public static List<ClassAnnotationDescriptor> parse(Annotation[] annotations) {
        if (null == annotations) {
            return NullList.instance;
        }
        ArrayList<ClassAnnotationDescriptor> ret = new ArrayList<ClassAnnotationDescriptor>();
        for (int i = 0; i < annotations.length; ++i) {
            ret.add(JavaClassAnnotationDescriptor.parse(annotations[i]));
        }
        return ret;
    }

    static {
        PROPS.addExaminer("type", e -> e.type);
        PROPS.addExaminer("data", e -> e.data);
    }
}

