/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import hu.ddsi.java.database.GenericStoreDataArray;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.GenericStoreMode;
import hu.ddsi.java.database.WrappedClassData;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreIgnore;
import java.lang.reflect.Field;
import java.util.Map;

public class FieldData
implements ExternalDataAttached,
ObjectWithProperty {
    public final Field f;
    public final GenericStoreDataType type;
    public final GenericStoreDataArray arr;
    public final int maxSize = 1000;
    private static final Field modifiersField = FieldData.modifierFields();
    @GenericStoreIgnore
    protected transient Map<String, Object> extraData;
    protected static ObjectWithPropertyStorage<FieldData> PROPS = new ObjectWithPropertyStorage();

    public FieldData(Field f) {
        this.f = f;
        FieldData.setFieldAccessible(this.f);
        GenericStoreDataType gtt = null;
        try {
            gtt = GenericStoreDataType.getStoreType(f);
        }
        catch (Exception e) {
            throw new RuntimeException("On field: " + f, e);
        }
        this.type = gtt;
        this.arr = this.type == GenericStoreDataType.Array ? GenericStoreDataArray.determineGenericStoreData(f) : null;
    }

    public FieldData(Field f, GenericStoreMode gsm) {
        this.f = f;
        FieldData.setFieldAccessible(this.f);
        if (GenericStoreMode.GenericStoreDont.equals((Object)gsm)) {
            this.type = null;
            this.arr = null;
        } else if (GenericStoreMode.GeneriStoreNative.equals((Object)gsm)) {
            GenericStoreDataType gtt;
            this.type = gtt = GenericStoreDataType.getStoreType(f);
            this.arr = this.type == GenericStoreDataType.Array ? GenericStoreDataArray.determineGenericStoreData(f) : null;
        } else {
            this.type = gsm.getGenericStoreDataType();
            this.arr = null;
        }
    }

    private static Field modifierFields() {
        Field f = null;
        try {
            f = Field.class.getDeclaredField("modifiers");
            f.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    private static void setFieldAccessible(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isArray() {
        return this.type == GenericStoreDataType.Array;
    }

    public Field getField() {
        return this.f;
    }

    public GenericStoreDataType getDataType() {
        return this.type;
    }

    public GenericStoreDataArray getArrayData() {
        return this.arr;
    }

    public int getMaxSize() {
        return 1000;
    }

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap();
        }
        return this.extraData;
    }

    public Object get(String key) {
        return PROPS.get((Object)this, key);
    }

    public String[] keys() {
        return PROPS.keys();
    }

    public boolean isStored() {
        return GenericStoreDataType.DontStore != this.type;
    }

    static {
        PROPS.addExaminer("type", e -> new WrappedClassData(e.f.getType()));
        PROPS.addExaminer("fieldName", e -> e.f.getName());
        PROPS.addExaminer("fieldStorageType", e -> e.type);
        PROPS.addExaminer("maxSize", e -> e.maxSize);
        PROPS.addExaminer("extraData", e -> e.getExtraDataMap());
        PROPS.addExaminer("arrayStorage", e -> e.getExtraDataMap());
    }
}

