/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import hu.ddsi.java.database.F;

public class GenericStoreQueryBuilder {

    public static class AtomicCondition {
        private final F operator;
        private final boolean negate;
        private final String field;
        private final Object value;

        public AtomicCondition(F operator, boolean negate, String field, Object val) {
            this.operator = operator;
            this.negate = negate;
            this.field = field;
            this.value = val;
        }

        public F getOperator() {
            return this.operator;
        }

        public boolean isNegated() {
            return this.negate;
        }

        public String getFieldName() {
            return this.field;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.field + " " + (this.negate ? "!" : "") + this.operator.name() + " " + this.value;
        }
    }

    public static interface ConditionInterface {
        public LogicalGroup not(String var1, Object var2);

        public LogicalGroup is(String var1, Object var2);
    }

    public static class LogicalGroup {
        public static LogicalGroup[] emptyLogicalGroupArray = new LogicalGroup[0];
        private final LogicalRelation lr;
        private final LogicalGroup[] components;
        private final AtomicCondition ac;

        public LogicalGroup(AtomicCondition ac) {
            this.ac = ac;
            this.components = null;
            this.lr = LogicalRelation.unit;
        }

        public LogicalGroup(LogicalRelation lr, LogicalGroup[] grp) {
            this.ac = null;
            this.components = grp;
            this.lr = lr;
        }

        public LogicalRelation getLogicalRelation() {
            return this.lr;
        }

        public AtomicCondition getAtomicCondition() {
            return this.ac;
        }

        public LogicalGroup[] getLogicalGroups() {
            return this.components;
        }

        public String toString() {
            if (null != this.ac) {
                return this.ac.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (LogicalGroup c : this.components) {
                if (sb.length() > 0) {
                    sb.append(" ");
                    sb.append(this.lr.name());
                    sb.append(" ");
                }
                sb.append(c.toString());
            }
            return sb.toString();
        }
    }

    public static enum LogicalRelation {
        and,
        or,
        unit;

    }
}

