/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreDataArray;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import java.util.List;

public abstract class GenericStoreDataWriter<D extends GenericStoreDatabase, W> {
    public abstract void writeField(String var1, FieldData var2, Object var3, W var4) throws Exception;

    public abstract void writeArrayField(String var1, GenericStoreDataArray var2, Object var3, W var4) throws Exception;

    public abstract W newWriter(D var1, Class<? extends GenericStorable> var2, boolean var3);

    public static Object conventToLongArray(GenericStorable[] arr, GenericStoreDatabase gdb) throws GenericStoreException {
        Long[] ret = new Long[arr.length];
        for (int i = 0; i < ret.length; ++i) {
            if (arr[i] == null) {
                ret[i] = -1L;
                continue;
            }
            long id = GenericStorage.getID(arr[i]);
            if (id == -1L) {
                GenericStorage.storeObject(arr[i], gdb);
            }
            ret[i] = GenericStorage.getID(arr[i]);
        }
        return ret;
    }

    public void writeObject(long id, GenericStorable stora, D gdb, FieldData[] fields, boolean update) throws Exception {
        W write = this.newWriter(gdb, stora.getClass(), update);
        for (FieldData fd : fields) {
            Object val = fd.getField().get(stora);
            if (fd.isArray()) {
                if (fd.getArrayData().primitivType == GenericStoreDataType.GenericDataId) {
                    this.writeArrayField(fd.getField().getName(), fd.getArrayData(), GenericStoreDataWriter.conventToLongArray((GenericStorable[])val, gdb), write);
                    continue;
                }
                this.writeArrayField(fd.getField().getName(), fd.getArrayData(), val, write);
                continue;
            }
            this.writeField(fd.getField().getName(), fd, val, write);
        }
        this.writeID(id, write);
        this.flushObject(write);
    }

    public abstract void flushObject(W var1) throws Exception;

    public abstract void writeID(long var1, W var3) throws Exception;

    public abstract void writeObjects(List<? extends GenericStorable> var1, GenericStoreDatabase var2, FieldData[] var3) throws Exception;
}

