/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import java.io.Closeable;
import java.io.IOException;

public class GenericStoreQueryResult<R extends Closeable>
implements Closeable {
    private final long[] ids;
    private final ResultUnit<R>[] results;

    public GenericStoreQueryResult(long[] ids, ResultUnit<R> ... results) {
        this.ids = ids;
        this.results = results;
    }

    public ResultUnit<R>[] getResults() {
        return this.results;
    }

    @Override
    public void close() throws IOException {
        for (ResultUnit<R> r : this.results) {
            r.close();
        }
    }

    public static class ResultUnit<R extends Closeable> {
        private final String returnClass;
        private final R cursor;

        public ResultUnit(String cls, R cur) {
            this.returnClass = cls;
            this.cursor = cur;
        }

        public String getReturnClass() {
            return this.returnClass;
        }

        public R getCursor() {
            return this.cursor;
        }

        public void close() throws IOException {
            this.cursor.close();
        }
    }
}

