/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database.JavaSQLImp;

import hu.ddsi.java.database.JavaSQLImp.SqlDialect;
import hu.ddsi.java.database.JavaSQLImp.dialects.MysqlDialect;
import hu.ddsi.java.database.JavaSQLImp.dialects.SqliteDialect;
import java.sql.Connection;

public enum WellKnownSqlDialects {
    MySql(new MysqlDialect()),
    PostgreSql(null),
    SqLite(new SqliteDialect());

    private final SqlDialect dialect;

    private WellKnownSqlDialects(SqlDialect dial) {
        this.dialect = dial;
    }

    public SqlDialect getDialectManager() {
        return this.dialect;
    }

    public static WellKnownSqlDialects recognise(Connection conn) {
        for (WellKnownSqlDialects v : WellKnownSqlDialects.values()) {
            try {
                if (!v.dialect.probeDialect(conn)) continue;
                return v;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Can't recognise Sql dialect of connection: " + conn);
    }
}

