/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.Mirror;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStoreDataArray;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.GenericStoreDatabase;
import java.lang.reflect.Array;
import java.util.Date;

public abstract class GenericStoreDataReader<T> {
    public static <T extends GenericStorable> T[] convBack(Long[] ids, Class<? extends T> desc, GenericStoreDatabase gdb) throws Exception {
        if (null == ids) {
            return null;
        }
        GenericStorable[] ret = (GenericStorable[])Array.newInstance(desc, ids.length);
        for (int i = 0; i < ret.length; ++i) {
            int index = i;
            if (ids[i] == -1L) {
                ret[i] = null;
                continue;
            }
            gdb.putPlacementRequest(desc, ids[i], (SimplePublish1<GenericStorable>)((SimplePublish1)e -> {
                ret[index] = e;
            }));
        }
        return ret;
    }

    public GenericStorable readObject(long id, T src, GenericStorable ret, GenericStoreDatabase db, FieldData[] fds) throws Exception {
        block11: for (FieldData fd : fds) {
            switch (fd.type) {
                case Boolean: 
                case Byte: 
                case Double: 
                case Float: 
                case Integer: 
                case Short: 
                case String: 
                case Long: {
                    Object obj = this.readField(fd.f.getName(), fd.type, src);
                    if (obj == null) continue block11;
                    fd.f.set(ret, obj);
                    continue block11;
                }
                case Date: {
                    fd.f.set(ret, (Date)this.readField(fd.f.getName(), fd.type, src));
                    continue block11;
                }
                case Array: {
                    if (fd.getArrayData().primitivType == GenericStoreDataType.GenericDataId) {
                        fd.f.set(ret, GenericStoreDataReader.convBack((Long[])((Long[])this.readArray(fd.f.getName(), fd.arr, src)), (Class)Mirror.getFinalComponentClass(fd.f.getType()), (GenericStoreDatabase)db));
                        continue block11;
                    }
                    fd.f.set(ret, this.readArray(fd.f.getName(), fd.arr, src));
                    continue block11;
                }
                case Enum: {
                    Object ob = this.readField(fd.f.getName(), fd.type, src);
                    if (ob == null) continue block11;
                    fd.f.set(ret, fd.f.getType().getEnumConstants()[(Integer)ob]);
                    continue block11;
                }
                case Serialized: {
                    fd.f.set(ret, this.readSerializedField(fd.f.getName(), src));
                    continue block11;
                }
                case GenericDataId: {
                    Object o = this.readField(fd.f.getName(), fd.type, src);
                    if (o == null) continue block11;
                    try {
                        db.putPlacementRequest(fd.f.getType(), ((Number)o).longValue(), (SimplePublish1<GenericStorable>)((SimplePublish1)e -> {
                            try {
                                fd.f.set(ret, e);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }));
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue block11;
                }
                case DontStore: {
                    continue block11;
                }
            }
        }
        return ret;
    }

    protected abstract Object readField(String var1, GenericStoreDataType var2, T var3) throws Exception;

    protected abstract Object readSerializedField(String var1, T var2) throws Exception;

    protected abstract Object[] readArray(String var1, GenericStoreDataArray var2, T var3) throws Exception;

    protected abstract String getClassBy(T var1) throws Exception;

    protected abstract long getIdBy(T var1) throws Exception;

    protected abstract boolean nextResult(T var1) throws Exception;

    protected abstract boolean setReadyToRead(T var1) throws Exception;
}

