/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database.test;

import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.ConnectionPool;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.query.F;
import eu.javaexperience.query.L;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.time.TimeCalc;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GsdbExtraCaluse;
import hu.ddsi.java.database.JavaSQLImp.SqlStorage;
import hu.ddsi.java.database.Limit;
import hu.ddsi.java.database.Offset;
import hu.ddsi.java.database.OrderBy;
import hu.ddsi.java.database.test.model.DChainHead;
import hu.ddsi.java.database.test.model.DEvent;
import hu.ddsi.java.database.test.model.DEventHeader;
import hu.ddsi.java.database.test.model.DLink;
import hu.ddsi.java.database.test.model.DSystemSource;
import hu.ddsi.java.database.test.model.DType;
import hu.ddsi.java.database.test.model.DUser;
import hu.ddsi.java.database.test.model.DbStringListEntry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public abstract class GsdbTest {
    protected ConnectionPool pool;
    protected static final String db = "test";

    protected static ConnectionCreator createUdsConnectionCreator(final String path, final String user, final String password, String db) {
        return new ConnectionCreator(){

            public Connection get() {
                try {
                    return DriverManager.getConnection("jdbc:mysql:///?socketFactory=hu.ddsi.java.database.test.UdsSocketFactory&socket=" + path, user, password);
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        };
    }

    protected GsdbTest(ConnectionPool pool) {
        this.pool = pool;
    }

    protected Connection openTestConnection(boolean reset) throws Throwable {
        Connection ret = this.pool.getConnection();
        ret.setCatalog(db);
        if (reset) {
            ArrayList tables = new ArrayList();
            JDBC.listTables((Connection)ret, tables);
            for (String s : tables) {
                JDBC.execute((Connection)ret, (String)("DROP TABLE `" + s + "`"));
            }
        }
        return ret;
    }

    protected GenericStoreDatabase openTestDatabase(boolean reset) throws Throwable {
        Connection db = this.openTestConnection(reset);
        return new SqlStorage(db, db);
    }

    @Test
    public void test_selectFromNonexistingTable() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            ArrayList users = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DUser.class, (LogicalGroup)F.eq.not("do", (Object)-1), users, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)0L, (long)users.size());
        }
    }

    @Test
    public void test_simpleSelect_KeepSession() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DUser usr = new DUser();
            usr.realFullName = "Dank\u00f3 D\u00e1vid";
            usr.notifyEmail = "info@dankodavid.hu";
            GenericStorage.storeObject((GenericStorable)usr, (GenericStoreDatabase)gdb);
            ArrayList users = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DUser.class, (LogicalGroup)F.eq.not("do", (Object)-1), users, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)users.size());
            DUser db = (DUser)((Object)users.get(0));
            Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)db.realFullName);
            Assert.assertEquals((Object)"info@dankodavid.hu", (Object)db.notifyEmail);
            Assert.assertTrue((usr == db ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_simpleSelect_DropSession() throws Throwable {
        DUser usr = null;
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            usr = new DUser();
            usr.realFullName = "Dank\u00f3 D\u00e1vid";
            usr.notifyEmail = "info@dankodavid.hu";
            GenericStorage.storeObject((GenericStorable)usr, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var3_3 = null;
        try {
            ArrayList users = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DUser.class, (LogicalGroup)F.eq.not("do", (Object)-1), users, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)users.size());
            DUser db = (DUser)((Object)users.get(0));
            Assert.assertEquals((Object)"Dank\u00f3 D\u00e1vid", (Object)db.realFullName);
            Assert.assertEquals((Object)"info@dankodavid.hu", (Object)db.notifyEmail);
            Assert.assertFalse((usr == db ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var3_3 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    @Test
    public void test_cyclicSave_keepSession() throws Throwable {
        DLink a = new DLink();
        DLink b = new DLink();
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            a.prev = a.next = b;
            b.prev = b.next = a;
            GenericStorage.storeObject((GenericStorable)a, (GenericStoreDatabase)gdb);
            ArrayList links = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links.size());
            DLink x = (DLink)((Object)links.get(0));
            DLink y = (DLink)((Object)links.get(1));
            Assert.assertTrue((x.prev == y ? 1 : 0) != 0);
            Assert.assertTrue((x.next == y ? 1 : 0) != 0);
            Assert.assertTrue((y.prev == x ? 1 : 0) != 0);
            Assert.assertTrue((y.next == x ? 1 : 0) != 0);
            Assert.assertTrue((a == x || b == x ? 1 : 0) != 0);
            Assert.assertTrue((a == y || b == y ? 1 : 0) != 0);
            long ia = x.getGenericStoreData().getID();
            long ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_cyclicSave_dropSession() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DLink b;
            DLink a = new DLink();
            a.prev = a.next = (b = new DLink());
            b.prev = b.next = a;
            GenericStorage.storeObject((GenericStorable)a, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            ArrayList links = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links.size());
            DLink x = (DLink)((Object)links.get(0));
            DLink y = (DLink)((Object)links.get(1));
            Assert.assertTrue((x.prev == y ? 1 : 0) != 0);
            Assert.assertTrue((x.next == y ? 1 : 0) != 0);
            Assert.assertTrue((y.prev == x ? 1 : 0) != 0);
            Assert.assertTrue((y.next == x ? 1 : 0) != 0);
            long ia = x.getGenericStoreData().getID();
            long ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    @Test
    public void test_updateToNull() throws Throwable {
        long ib;
        long ia;
        DLink y;
        DLink x;
        ArrayList links2;
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DLink b;
            DLink a = new DLink();
            a.prev = a.next = (b = new DLink());
            b.prev = b.next = a;
            GenericStorage.storeObject((GenericStorable)a, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            links2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links2.size());
            x = (DLink)((Object)links2.get(0));
            y = (DLink)((Object)links2.get(1));
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.prev));
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.next));
            Assert.assertEquals((Object)((Object)x), (Object)((Object)y.prev));
            Assert.assertEquals((Object)((Object)x), (Object)((Object)y.next));
            ia = x.getGenericStoreData().getID();
            ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
            x.next = null;
            x.prev = null;
            y.next = null;
            y.prev = null;
            x.dbMarkModified();
            y.dbMarkModified();
            GenericStorage.storeObject((GenericStorable)x, (GenericStoreDatabase)gdb);
            GenericStorage.storeObject((GenericStorable)y, (GenericStoreDatabase)gdb);
        }
        catch (Throwable links2) {
            var2_2 = links2;
            throw links2;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable links2) {
                        var2_2.addSuppressed(links2);
                    }
                } else {
                    gdb.close();
                }
            }
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            links2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links2.size());
            x = (DLink)((Object)links2.get(0));
            y = (DLink)((Object)links2.get(1));
            Assert.assertNull((Object)((Object)x.prev));
            Assert.assertNull((Object)((Object)x.next));
            Assert.assertNull((Object)((Object)y.prev));
            Assert.assertNull((Object)((Object)y.next));
            ia = x.getGenericStoreData().getID();
            ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    @Test
    public void test_updateToNull_saveDirection() throws Throwable {
        long ib;
        DLink y;
        DLink x;
        ArrayList links2;
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DLink b;
            DLink a = new DLink();
            a.prev = a.next = (b = new DLink());
            b.prev = b.next = a;
            GenericStorage.storeObject((GenericStorable)a, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            links2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links2.size());
            x = (DLink)((Object)links2.get(0));
            y = (DLink)((Object)links2.get(1));
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.prev));
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.next));
            Assert.assertEquals((Object)((Object)x), (Object)((Object)y.prev));
            Assert.assertEquals((Object)((Object)x), (Object)((Object)y.next));
            long ia = x.getGenericStoreData().getID();
            ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
            y.next = null;
            y.prev = null;
            x.dbMarkModified();
            y.dbMarkModified();
            GenericStorage.storeObject((GenericStorable)x, (GenericStoreDatabase)gdb);
        }
        catch (Throwable links2) {
            var2_2 = links2;
            throw links2;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable links2) {
                        var2_2.addSuppressed(links2);
                    }
                } else {
                    gdb.close();
                }
            }
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            links2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DLink.class, (LogicalGroup)F.eq.not("do", (Object)-1), links2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)2L, (long)links2.size());
            x = (DLink)((Object)links2.get(0));
            y = (DLink)((Object)links2.get(1));
            if (null != y.prev && null == x.prev) {
                DLink l = x;
                x = y;
                y = l;
            }
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.prev));
            Assert.assertEquals((Object)((Object)y), (Object)((Object)x.next));
            Assert.assertNull((Object)((Object)y.prev));
            Assert.assertNull((Object)((Object)y.next));
            long ia = x.getGenericStoreData().getID();
            ib = y.getGenericStoreData().getID();
            Assert.assertTrue((ia == 1L || ia == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ib == 1L || ib == 2L ? 1 : 0) != 0);
            Assert.assertTrue((ia != ib ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    @Test
    public void test_zigzagSave_then_updateToNull_2_keepSession() throws Throwable {
        Date now = new Date();
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DEventHeader eh = new DEventHeader();
            eh.from = TimeCalc.startOfTime;
            eh.to = TimeCalc.endOfTime;
            DSystemSource dss = new DSystemSource();
            dss.createdOn = now;
            dss.issuerUnit = "test system";
            dss.sourceEventType = db;
            eh.source = dss;
            DEvent ev = new DEvent();
            ev.type = DType.CREATE;
            ev.at = now;
            ev.owner = eh;
            GenericStorage.storeObject((GenericStorable)ev, (GenericStoreDatabase)gdb);
            ArrayList evs = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DEvent.class, (LogicalGroup)F.eq.not("do", (Object)-1), evs, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)evs.size());
            DEvent ev2 = (DEvent)((Object)evs.get(0));
            Assert.assertEquals((Object)((Object)DType.CREATE), (Object)((Object)ev2.type));
            Assert.assertEquals((Object)now, (Object)ev2.at);
            Assert.assertNotNull((Object)((Object)ev2.owner));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev2.owner.from);
            Assert.assertEquals((Object)TimeCalc.endOfTime, (Object)ev2.owner.to);
            Assert.assertTrue((boolean)(ev2.owner.source instanceof DSystemSource));
            DSystemSource dss2 = (DSystemSource)ev2.owner.source;
            Assert.assertEquals((Object)now, (Object)dss2.createdOn);
            Assert.assertEquals((Object)"test system", (Object)dss2.issuerUnit);
            Assert.assertEquals((Object)db, (Object)dss2.sourceEventType);
            ev2.type = DType.MODIFY;
            ev2.at = TimeCalc.startOfTime;
            ev2.owner.to = null;
            dss2.issuerUnit = null;
            dss2.sourceEventType = "test2";
            ev2.dbMarkModified();
            dss2.dbMarkModified();
            GenericStorage.storeAll((GenericStoreDatabase)gdb, (GenericStorable[])new GenericStorable[]{ev2, dss2});
            evs = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DEvent.class, (LogicalGroup)F.eq.not("do", (Object)-1), evs, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)evs.size());
            ev2 = (DEvent)((Object)evs.get(0));
            Assert.assertEquals((Object)((Object)DType.MODIFY), (Object)((Object)ev2.type));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev2.at);
            Assert.assertNotNull((Object)((Object)ev2.owner));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev2.owner.from);
            Assert.assertNull((Object)ev2.owner.to);
            Assert.assertTrue((boolean)(ev2.owner.source instanceof DSystemSource));
            dss2 = (DSystemSource)ev2.owner.source;
            Assert.assertEquals((Object)now, (Object)dss2.createdOn);
            Assert.assertNull((Object)dss2.issuerUnit);
            Assert.assertEquals((Object)"test2", (Object)dss2.sourceEventType);
        }
    }

    @Test
    public void test_zigzagSave_then_updateToNull_2_dropSession() throws Throwable {
        DSystemSource dss;
        DEvent ev;
        ArrayList evs2;
        Date now = new Date();
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DEventHeader eh = new DEventHeader();
            eh.from = TimeCalc.startOfTime;
            eh.to = TimeCalc.endOfTime;
            DSystemSource dss2 = new DSystemSource();
            dss2.createdOn = now;
            dss2.issuerUnit = "test system";
            dss2.sourceEventType = db;
            eh.source = dss2;
            DEvent ev2 = new DEvent();
            ev2.type = DType.CREATE;
            ev2.at = now;
            ev2.owner = eh;
            GenericStorage.storeObject((GenericStorable)ev2, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var3_3 = null;
        try {
            evs2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DEvent.class, (LogicalGroup)F.eq.not("do", (Object)-1), evs2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)evs2.size());
            ev = (DEvent)((Object)evs2.get(0));
            Assert.assertEquals((Object)((Object)DType.CREATE), (Object)((Object)ev.type));
            Assert.assertEquals((Object)now, (Object)ev.at);
            Assert.assertNotNull((Object)((Object)ev.owner));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev.owner.from);
            Assert.assertEquals((Object)TimeCalc.endOfTime, (Object)ev.owner.to);
            Assert.assertTrue((boolean)(ev.owner.source instanceof DSystemSource));
            dss = (DSystemSource)ev.owner.source;
            Assert.assertEquals((Object)now, (Object)dss.createdOn);
            Assert.assertEquals((Object)"test system", (Object)dss.issuerUnit);
            Assert.assertEquals((Object)db, (Object)dss.sourceEventType);
            ev.type = DType.MODIFY;
            ev.at = TimeCalc.startOfTime;
            ev.owner.to = null;
            dss.issuerUnit = null;
            dss.sourceEventType = "test2";
            ev.owner.dbMarkModified();
            ev.dbMarkModified();
            dss.dbMarkModified();
            GenericStorage.storeAll((GenericStoreDatabase)gdb, (GenericStorable[])new GenericStorable[]{ev, dss});
        }
        catch (Throwable evs2) {
            var3_3 = evs2;
            throw evs2;
        }
        finally {
            if (gdb != null) {
                if (var3_3 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable evs2) {
                        var3_3.addSuppressed(evs2);
                    }
                } else {
                    gdb.close();
                }
            }
        }
        gdb = this.openTestDatabase(false);
        var3_3 = null;
        try {
            evs2 = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DEvent.class, (LogicalGroup)F.eq.not("do", (Object)-1), evs2, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)evs2.size());
            ev = (DEvent)((Object)evs2.get(0));
            Assert.assertEquals((Object)((Object)DType.MODIFY), (Object)((Object)ev.type));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev.at);
            Assert.assertNotNull((Object)((Object)ev.owner));
            Assert.assertEquals((Object)TimeCalc.startOfTime, (Object)ev.owner.from);
            Assert.assertNull((Object)ev.owner.to);
            Assert.assertTrue((boolean)(ev.owner.source instanceof DSystemSource));
            dss = (DSystemSource)ev.owner.source;
            Assert.assertEquals((Object)now, (Object)dss.createdOn);
            Assert.assertNull((Object)dss.issuerUnit);
            Assert.assertEquals((Object)"test2", (Object)dss.sourceEventType);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var3_3 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    protected static void assertCrossChained(DLink x, DLink y) {
        Assert.assertEquals((Object)((Object)y), (Object)((Object)x.prev));
        Assert.assertEquals((Object)((Object)y), (Object)((Object)x.next));
        Assert.assertEquals((Object)((Object)x), (Object)((Object)y.prev));
        Assert.assertEquals((Object)((Object)x), (Object)((Object)y.next));
        long ia = x.getGenericStoreData().getID();
        long ib = y.getGenericStoreData().getID();
        Assert.assertTrue((ia != ib ? 1 : 0) != 0);
    }

    @Test
    public void test_saveRestoreGsArray_keepSession() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DLink b;
            DLink a = new DLink();
            a.prev = a.next = (b = new DLink());
            b.prev = b.next = a;
            DChainHead head = new DChainHead();
            head.links = new DLink[]{a, b};
            GenericStorage.storeObject((GenericStorable)head, (GenericStoreDatabase)gdb);
            ArrayList linkHeads = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DChainHead.class, (LogicalGroup)F.eq.not("do", (Object)-1), linkHeads, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)linkHeads.size());
            DChainHead l = (DChainHead)((Object)linkHeads.get(0));
            GsdbTest.assertCrossChained(l.links[0], l.links[1]);
        }
    }

    @Test
    public void test_saveRestoreGsArray_dropSession() throws Throwable {
        DLink a = new DLink();
        DLink b = new DLink();
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            a.prev = a.next = b;
            b.prev = b.next = a;
            DChainHead head = new DChainHead();
            head.links = new DLink[]{a, b};
            GenericStorage.storeObject((GenericStorable)head, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var4_4 = null;
        try {
            ArrayList linkHeads = new ArrayList();
            GenericStorage.getAllObjectsByQuery(DChainHead.class, (LogicalGroup)F.eq.not("do", (Object)-1), linkHeads, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
            Assert.assertEquals((long)1L, (long)linkHeads.size());
            DChainHead l = (DChainHead)((Object)linkHeads.get(0));
            GsdbTest.assertCrossChained(l.links[0], l.links[1]);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var4_4 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    @Test
    public void test_getById1() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DLink a = new DLink();
            DLink b = new DLink();
            DUser usr = new DUser();
            usr.realFullName = "Dank\u00f3 D\u00e1vid";
            usr.notifyEmail = "info@dankodavid.hu";
            GenericStorage.storeObject((GenericStorable)usr, (GenericStoreDatabase)gdb);
            GenericStorage.storeObject((GenericStorable)a, (GenericStoreDatabase)gdb);
            GenericStorage.storeObject((GenericStorable)b, (GenericStoreDatabase)gdb);
            DEventHeader eh = new DEventHeader();
            eh.from = TimeCalc.startOfTime;
            eh.to = TimeCalc.endOfTime;
            DSystemSource dss = new DSystemSource();
            dss.issuerUnit = "test system";
            dss.sourceEventType = db;
            eh.source = dss;
            DEvent ev = new DEvent();
            ev.type = DType.CREATE;
            ev.owner = eh;
            GenericStorage.storeObject((GenericStorable)ev, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            Assert.assertTrue((boolean)(GenericStorage.getObjectByID((long)1L, (GenericStoreDatabase)gdb) instanceof DUser));
            Assert.assertTrue((boolean)(GenericStorage.getObjectByID((long)2L, (GenericStoreDatabase)gdb) instanceof DLink));
            Assert.assertTrue((boolean)(GenericStorage.getObjectByID((long)3L, (GenericStoreDatabase)gdb) instanceof DLink));
            HashSet<Class> clss = new HashSet<Class>();
            clss.add(DEventHeader.class);
            clss.add(DSystemSource.class);
            clss.add(DEvent.class);
            Assert.assertTrue((boolean)GsdbTest.isAnyOfThenRemove(GenericStorage.getObjectByID((long)4L, (GenericStoreDatabase)gdb), clss));
            Assert.assertTrue((boolean)GsdbTest.isAnyOfThenRemove(GenericStorage.getObjectByID((long)5L, (GenericStoreDatabase)gdb), clss));
            Assert.assertTrue((boolean)GsdbTest.isAnyOfThenRemove(GenericStorage.getObjectByID((long)6L, (GenericStoreDatabase)gdb), clss));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    public static boolean isAnyOfThenRemove(Object o, Collection<Class> clss) {
        if (clss.contains(o.getClass())) {
            clss.remove(o.getClass());
            return true;
        }
        return false;
    }

    @Test
    public void test_orderLimitOffset() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            ArrayList<DbStringListEntry> ents = new ArrayList<DbStringListEntry>();
            for (int i = 0; i < 1000; ++i) {
                DbStringListEntry ent = new DbStringListEntry();
                ent.order = i;
                ent.entry = String.valueOf(i);
                ents.add(ent);
            }
            GenericStorage.storeAll(ents, (GenericStoreDatabase)gdb);
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            for (int o = 0; o < 100; ++o) {
                ArrayList ents = new ArrayList();
                GenericStorage.getObjectsByQuery((GenericStoreDatabase)gdb, ents, DbStringListEntry.class, (LogicalGroup)F.gt.is("do", (Object)"-1"), (GsdbExtraCaluse[])new GsdbExtraCaluse[]{OrderBy.asc((String)"order"), Offset.offset((int)(10 * o)), Limit.limit((int)10)});
                for (int i = 0; i < 10; ++i) {
                    Assert.assertEquals((long)((DbStringListEntry)((Object)ents.get((int)i))).order, (long)(10 * o + i));
                }
            }
        }
        catch (Throwable o) {
            var2_2 = o;
            throw o;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable o) {
                        var2_2.addSuppressed(o);
                    }
                } else {
                    gdb.close();
                }
            }
        }
        gdb = this.openTestDatabase(false);
        var2_2 = null;
        try {
            for (int o = 0; o < 100; ++o) {
                ArrayList ents = new ArrayList();
                GenericStorage.getObjectsByQuery((GenericStoreDatabase)gdb, ents, DbStringListEntry.class, (LogicalGroup)F.gt.is("do", (Object)"-1"), (GsdbExtraCaluse[])new GsdbExtraCaluse[]{OrderBy.desc((String)"order"), Offset.offset((int)(10 * o)), Limit.limit((int)10)});
                for (int i = 0; i < 10; ++i) {
                    Assert.assertEquals((long)((DbStringListEntry)((Object)ents.get((int)i))).order, (long)(999 - (10 * o + i)));
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (gdb != null) {
                if (var2_2 != null) {
                    try {
                        gdb.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    gdb.close();
                }
            }
        }
    }

    protected static void testStringSaveSearch(GenericStoreDatabase gdb, int order, String content) throws GenericStoreException {
        DbStringListEntry ent = new DbStringListEntry();
        ent.order = order;
        ent.entry = content;
        GenericStorage.post((GenericStoreDatabase)gdb, (GenericStorable)ent);
        ArrayList ret = new ArrayList();
        GenericStorage.getAllObjectsByQuery(DbStringListEntry.class, (LogicalGroup)L.and((LogicalGroup[])new LogicalGroup[]{F.eq.is("order", (Object)order), F.eq.is("entry", (Object)content)}), ret, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
        Assert.assertEquals((long)1L, (long)ret.size());
        DbStringListEntry e = (DbStringListEntry)((Object)ret.get(0));
        Assert.assertEquals((long)order, (long)e.order);
        Assert.assertEquals((Object)content, (Object)e.entry);
        ret = new ArrayList();
        GenericStorage.getAllObjectsByQuery(DbStringListEntry.class, (LogicalGroup)L.and((LogicalGroup[])new LogicalGroup[]{F.eq.is("order", (Object)order), F.contains.is("entry", (Object)content)}), ret, (GenericStoreDatabase)gdb, (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
        Assert.assertEquals((long)1L, (long)ret.size());
        e = (DbStringListEntry)((Object)ret.get(0));
        Assert.assertEquals((long)order, (long)e.order);
        Assert.assertEquals((Object)content, (Object)e.entry);
    }

    @Test
    public void test_str_escape() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            GsdbTest.testStringSaveSearch(gdb, 0, "John's workshop");
            GsdbTest.testStringSaveSearch(gdb, 1, "John\"s workshop");
            GsdbTest.testStringSaveSearch(gdb, 2, "\"Doomsday Machine\"");
            GsdbTest.testStringSaveSearch(gdb, 3, "'Doomsday Machine'");
            GsdbTest.testStringSaveSearch(gdb, 4, "Dr Wu's \"Doomsday Machine\"");
            GsdbTest.testStringSaveSearch(gdb, 5, "'Dr Wu's \"Doomsday Machine\"\"");
            GsdbTest.testStringSaveSearch(gdb, 6, "\\'\"Dr Wu\\'\\\"s \"Doomsday Machine\"\"");
            GsdbTest.testStringSaveSearch(gdb, 7, "\\''\\\"\\'\\\"");
        }
    }

    @Test
    public void test_remove() throws Throwable {
        try (GenericStoreDatabase gdb = this.openTestDatabase(true);){
            DbStringListEntry e1 = new DbStringListEntry();
            e1.entry = "Str1";
            DbStringListEntry e2 = new DbStringListEntry();
            e2.entry = "Str1";
            GenericStorage.storeObject((GenericStorable)e1, (GenericStoreDatabase)gdb);
            GenericStorage.storeObject((GenericStorable)e2, (GenericStoreDatabase)gdb);
            Assert.assertTrue((gdb == GenericStorage.getOwnerDatabase((GenericStorable)e1) ? 1 : 0) != 0);
            Assert.assertTrue((gdb == GenericStorage.getOwnerDatabase((GenericStorable)e2) ? 1 : 0) != 0);
            GenericStorage.removeObject((GenericStorable)e1, (GenericStoreDatabase)gdb);
            Assert.assertTrue((null == GenericStorage.getOwnerDatabase((GenericStorable)e1) ? 1 : 0) != 0);
            Assert.assertTrue((gdb == GenericStorage.getOwnerDatabase((GenericStorable)e2) ? 1 : 0) != 0);
        }
    }
}

