/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.functional.BoolFunctions;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import hu.ddsi.java.database.WrappedFieldData;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class WrappedClassData
implements ObjectWithProperty {
    protected Class type;
    public boolean shallow = false;
    protected GetBy1<Boolean, Field> fieldSelector;
    protected static ObjectWithPropertyStorage<WrappedClassData> PROPS = new ObjectWithPropertyStorage();

    public WrappedClassData(Class<?> type) {
        this.type = type;
        this.fieldSelector = BoolFunctions.always();
    }

    public WrappedClassData(Class c, GetBy1<Boolean, Field> fieldSelector) {
        this.type = c;
        this.fieldSelector = fieldSelector;
    }

    public Object get(String key) {
        return PROPS.get((Object)this, key);
    }

    public String[] keys() {
        return PROPS.keys();
    }

    @MayNull
    public static WrappedClassData wrap(Class c, GetBy1<Boolean, Field> fieldSelector) {
        if (null == c) {
            return null;
        }
        return new WrappedClassData(c, fieldSelector);
    }

    @MayNull
    public static WrappedClassData[] wrap(Class[] c, GetBy1<Boolean, Field> fieldSelector) {
        if (null == c) {
            return null;
        }
        WrappedClassData[] ret = new WrappedClassData[c.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = WrappedClassData.wrap(c[i], fieldSelector);
        }
        return ret;
    }

    protected Object extractSuperClass() {
        if (this.shallow) {
            Class cls = this.type.getSuperclass();
            if (null == cls) {
                return null;
            }
            return cls.getName();
        }
        return WrappedClassData.wrap(this.type.getSuperclass(), this.fieldSelector);
    }

    protected Object extractInterface() {
        if (this.shallow) {
            Class<?>[] cls = this.type.getInterfaces();
            if (null == cls) {
                return null;
            }
            String[] ret = new String[cls.length];
            int i = 0;
            for (Class<?> c : cls) {
                ret[i++] = c.getName();
            }
            return ret;
        }
        return WrappedClassData.wrap(this.type.getInterfaces(), this.fieldSelector);
    }

    public static void discoverAndWrapShallow(Map<Class, WrappedClassData> map, Class c, boolean discoverFields) {
        if (null == c) {
            return;
        }
        if (!map.containsKey(c)) {
            WrappedClassData wc = new WrappedClassData(c);
            wc.shallow = true;
            WrappedClassData.discoverAndWrapShallow(map, c.getSuperclass(), discoverFields);
            for (Class<?> clazz : c.getInterfaces()) {
                WrappedClassData.discoverAndWrapShallow(map, clazz, discoverFields);
            }
            if (discoverFields) {
                for (AnnotatedElement annotatedElement : Mirror.getClassData((Class)c).select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
                    WrappedClassData.discoverAndWrapShallow(map, ((Field)annotatedElement).getType(), discoverFields);
                }
            }
        }
    }

    static {
        PROPS.addExaminer("name", e -> e.type.getSimpleName());
        PROPS.addExaminer("fullName", e -> e.type.getName());
        PROPS.addExaminer("superClass", e -> e.extractSuperClass());
        PROPS.addExaminer("superInterfaces", e -> e.extractInterface());
        PROPS.addExaminer("isArray", e -> e.type.isArray());
        PROPS.addExaminer("isEnum", e -> e.type.isEnum());
        PROPS.addExaminer("arrayComponent", e -> WrappedClassData.wrap(e.type.getComponentType(), e.fieldSelector));
        PROPS.addExaminer("enums", e -> e.type.getEnumConstants());
        PROPS.addExaminer("isInterface", e -> e.type.isInterface());
        PROPS.addExaminer("isAbstract", e -> Modifier.isAbstract(e.type.getModifiers()));
        PROPS.addExaminer("modifiers", e -> e.type.getModifiers());
        PROPS.addExaminer("fields", e -> WrappedFieldData.wrapAll(e.type.getFields(), e.fieldSelector));
    }
}

