/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDataArray;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreIgnore;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreNative;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreSerialized;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreStorableID;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;

public enum GenericStoreDataType {
    DontStore(Void.TYPE, SimpleDataType.dontStore),
    Boolean(java.lang.Boolean.TYPE, SimpleDataType.sint32),
    Byte(java.lang.Byte.TYPE, SimpleDataType.sint32),
    Char(Character.TYPE, SimpleDataType.string),
    Short(java.lang.Short.TYPE, SimpleDataType.sint32),
    Integer(java.lang.Integer.TYPE, SimpleDataType.sint32),
    Enum(java.lang.Integer.TYPE, SimpleDataType.sint32),
    Float(java.lang.Float.TYPE, SimpleDataType.doublefloat64),
    Long(java.lang.Long.TYPE, SimpleDataType.slongint64),
    Double(java.lang.Double.TYPE, SimpleDataType.doublefloat64),
    Date(Long.class, SimpleDataType.slongint64),
    String(String.class, SimpleDataType.string),
    GenericDataId(java.lang.Long.TYPE, SimpleDataType.slongint64),
    Serialized(byte[].class, SimpleDataType.blob),
    Array(GenericStoreDataArray.class, SimpleDataType.array);

    private final Class<?> javaType;
    private final SimpleDataType simpleType;

    public Class<?> getJavaTransferClass() {
        return this.javaType;
    }

    private GenericStoreDataType(Class<?> transferType, SimpleDataType simple) {
        this.javaType = transferType;
        this.simpleType = simple;
    }

    public static GenericStoreDataType getStoreType(Field f) {
        GenericStoreDataType ret;
        boolean throwExcpetion = true;
        Annotation[] ann = f.getAnnotations();
        if (null == ann) {
            throwExcpetion = false;
            if (Modifier.isTransient(f.getModifiers())) {
                return DontStore;
            }
        }
        if (null == (ret = GenericStoreDataType.getStoreType(f.getType(), ann, throwExcpetion))) {
            return DontStore;
        }
        return ret;
    }

    public static GenericStoreDataType getStoreType(Class<?> t, Annotation[] anns) {
        return GenericStoreDataType.getStoreType(t, anns, true);
    }

    public static GenericStoreDataType getStoreType(Class<?> t, Annotation[] anns, boolean throwException) {
        boolean store = false;
        if (null != anns) {
            for (Annotation a : anns) {
                if (a instanceof GenericStoreIgnore) {
                    return DontStore;
                }
                if (a instanceof GenericStoreStorableID) {
                    if (t.isArray()) {
                        return Array;
                    }
                    return GenericDataId;
                }
                if (a instanceof GenericStoreSerialized) {
                    return Serialized;
                }
                if (!(a instanceof GenericStoreNative)) continue;
                store = true;
                break;
            }
        }
        if (t.isArray()) {
            return Array;
        }
        if (java.lang.Boolean.TYPE.equals(t) || Boolean.class.equals(t)) {
            return Boolean;
        }
        if (java.lang.Byte.TYPE.equals(t) || Byte.class.equals(t)) {
            return Byte;
        }
        if (Character.TYPE.equals(t) || Character.class.equals(t)) {
            return Char;
        }
        if (java.lang.Short.TYPE.equals(t) || Short.class.equals(t)) {
            return Short;
        }
        if (java.lang.Integer.TYPE.equals(t) || Integer.class.equals(t)) {
            return Integer;
        }
        if (java.lang.Long.TYPE.equals(t) || Long.class.equals(t)) {
            return Long;
        }
        if (java.lang.Float.TYPE.equals(t) || Float.class.equals(t)) {
            return Float;
        }
        if (java.lang.Double.TYPE.equals(t) || Double.class.equals(t)) {
            return Double;
        }
        if (String.class.equals(t)) {
            return String;
        }
        if (Date.class.equals(t)) {
            return Date;
        }
        if (t.isEnum()) {
            return Enum;
        }
        if (GenericStorable.class.isAssignableFrom(t)) {
            return GenericDataId;
        }
        if (store) {
            return Serialized;
        }
        if (GenericStoreData.class == t) {
            return DontStore;
        }
        if (throwException) {
            throw new UnimplementedCaseException("Case for class:" + t + (null == t ? "" : " (" + t.getName() + ")") + " is unimplemented");
        }
        return null;
    }

    public static enum SimpleDataType {
        dontStore,
        sint32,
        slongint64,
        string,
        blob,
        array,
        doublefloat64;

    }
}

