/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database.JavaSQLImp;

import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.query.LogicalRelation;
import eu.javaexperience.reflect.Mirror;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDataReader;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.GenericStoreDataWriter;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GenericStoreQueryResult;
import hu.ddsi.java.database.JavaSQLImp.SqlDialect;
import hu.ddsi.java.database.JavaSQLImp.SqlStorageReader;
import hu.ddsi.java.database.JavaSQLImp.SqlStorageWriter;
import hu.ddsi.java.database.JavaSQLImp.WellKnownSqlDialects;
import hu.ddsi.java.database.JavaSQLImp.dialects.MysqlDialect;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SqlStorage
extends GenericStoreDatabase
implements Closeable {
    final Connection connection;
    final String quote;
    final String strQuote;
    private final String idSelect;
    private final String idUpdate;
    public static final String baseDBName = GenericStorable.class.getName();
    private String dbName;
    protected final SqlDialect dialect;
    private static final GenericStoreDataWriter writer = new SqlStorageWriter();
    private static final GenericStoreDataReader<AutoCloseOnFinalizeRS> reader = new SqlStorageReader();
    protected final GetBy1<String, Object> formatValue = new GetBy1<String, Object>(){

        public String getBy(Object a) {
            if (null == a) {
                return "null";
            }
            if (a instanceof Date) {
                return String.valueOf(((Date)a).getTime());
            }
            if (a instanceof GenericStorable) {
                return String.valueOf(GenericStorage.getID((GenericStorable)a));
            }
            return SqlStorage.this.quote(a.toString());
        }
    };

    public SqlStorage(Connection conn, String database) throws SQLException, GenericStoreException {
        this.connection = conn;
        this.dbName = database;
        this.connection.setCatalog(this.dbName);
        this.dialect = WellKnownSqlDialects.recognise(conn).getDialectManager();
        this.quote = this.dialect.getFieldQuoteString();
        this.strQuote = this.dialect.getStringQuote();
        this.idSelect = "SELECT * FROM " + this.quote + baseDBName + this.quote + " WHERE " + this.quote + "do" + this.quote + "=0;";
        this.idUpdate = "UPDATE " + this.quote + baseDBName + this.quote + " SET " + this.quote + "curId" + this.quote + "= ?  WHERE " + this.quote + "do" + this.quote + "=0 AND " + this.quote + "curId" + this.quote + " = ?;";
        this.init();
        this.mustCallAfterConnectionEstablishedBeforeUse();
    }

    @Override
    public GenericStoreDataWriter getWriter(String cls) throws Exception {
        return writer;
    }

    @Override
    public GenericStoreQueryResult getIDListByQuery(Class<? extends GenericStorable> cls, LogicalGroup lg, boolean all_field) throws Exception {
        Class<? extends GenericStorable> crnt = cls;
        StringBuilder sb = new StringBuilder();
        if (all_field) {
            sb.append("SELECT * FROM ");
        } else {
            sb.append("SELECT do FROM ");
        }
        sb.append(this.quote);
        sb.append(crnt.getName());
        sb.append(this.quote);
        sb.append(" WHERE ");
        this.buildQuery(sb, lg);
        sb.append(" ;");
        Statement st = this.connection.createStatement();
        ResultSet rs = st.executeQuery(sb.toString());
        long[] ret = Mirror.emptyNLongArray;
        return new GenericStoreQueryResult(ret, new GenericStoreQueryResult.ResultUnit<AutoCloseOnFinalizeRS>(cls.getName(), new AutoCloseOnFinalizeRS(st, rs)));
    }

    @Override
    public void createStorageForClass(Class<? extends GenericStorable> cls, FieldData[] data) throws Exception {
        String[] tabs = SqlStorage.getTables(this.connection);
        String clsn = cls.getName();
        for (String t : tabs) {
            if (!clsn.equalsIgnoreCase(t)) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.quote);
        sb.append(clsn);
        sb.append(this.quote);
        sb.append(" (");
        sb.append(this.quote);
        sb.append("do");
        sb.append(this.quote);
        sb.append(" ");
        sb.append(this.dialect.getCreatePrimitiveKey(Long.class, true, true, true, true));
        for (FieldData fd : data) {
            if (GenericStoreDataType.DontStore == fd.type) continue;
            sb.append(",");
            sb.append(this.quote);
            sb.append(fd.getField().getName());
            sb.append(this.quote);
            sb.append(this.dialect.getSqlType(fd));
        }
        sb.append(")");
        String opts = this.dialect.getOtherTableCreateOptions();
        if (null != opts) {
            sb.append(opts);
        }
        try (Statement st = this.connection.createStatement();){
            st.execute(sb.toString());
        }
    }

    @Override
    public void dropClassStorageImpl(Class<? extends GenericStorable> cls) throws Exception {
        ++this.modificationCount;
        try (Statement st = this.connection.createStatement();){
            st.execute("DROP TABLE " + this.quote + cls.getName() + this.quote);
        }
    }

    @Override
    public void deleteObjectByIDSByClass(long[] id, Class<? extends GenericStorable>[] cls) throws Exception {
        int i;
        ++this.modificationCount;
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (i = 0; i < id.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(id[i]);
            this.cache.remove(id[i]);
        }
        sb.append(")");
        for (i = 0; i < id.length; ++i) {
            this.cache.remove(id[i]);
        }
        try (Statement st = this.connection.createStatement();){
            for (Class<? extends GenericStorable> c : cls) {
                st.execute("DELETE FROM " + this.quote + c.getName() + this.quote + " WHERE do IN" + sb);
            }
        }
    }

    @Override
    public String[] listStoredClasses() throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        DatabaseMetaData md = this.connection.getMetaData();
        try (ResultSet rs = md.getTables(this.dbName, null, "%", null);){
            while (rs.next()) {
                ret.add(rs.getString(3));
            }
        }
        return ret.toArray(Mirror.emptyStringArray);
    }

    @Override
    public GenericStoreDataReader getReader(String cls) throws Exception {
        return reader;
    }

    @Override
    protected void storeAll(Map<Class<? extends GenericStorable>, List<? extends GenericStorable>> map) throws Exception {
        for (Map.Entry<Class<? extends GenericStorable>, List<? extends GenericStorable>> kv : map.entrySet()) {
            Class<? extends GenericStorable> cls = kv.getKey();
            List<? extends GenericStorable> objects = kv.getValue();
            if (objects.size() <= 0) continue;
            GenericStorable inst = objects.get(0);
            GenericStoreDataWriter writer = this.getWriter(cls.getName());
            FieldData[] fds = SqlStorage.getOrCreateFieldData(cls);
            writer.writeObjects(objects, this, fds);
        }
    }

    @Override
    protected List<Long> reserveNextIDRangeAtomic(int size) throws Exception {
        if (size > 0) {
            for (int i = 0; i < 150; ++i) {
                ++this.modificationCount;
                long now = this.getCurrentId();
                try (PreparedStatement st = this.connection.prepareStatement(this.idUpdate);){
                    st.setLong(1, now + (long)size);
                    st.setLong(2, now);
                    if (st.executeUpdate() <= 0) continue;
                    ArrayList<Long> ret = new ArrayList<Long>();
                    long end = now + 1L + (long)size;
                    for (long l = now + 1L; l < end; ++l) {
                        ret.add(l);
                    }
                    ArrayList<Long> arrayList = ret;
                    return arrayList;
                }
            }
            throw new RuntimeException("Can't reserve next id range after 150 retry.");
        }
        return NullList.instance;
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getCurrentId() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkAndAddColumns() throws Exception {
        for (String cls : this.listStoredClasses()) {
            try {
                Class c = SqlStorage.forName(cls);
                if (null == c || c.isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
                FieldData[] fds = SqlStorage.getOrCreateFieldData(c);
                ArrayList<FieldData> toAdd = new ArrayList<FieldData>();
                ArrayList<String> dbf = new ArrayList<String>();
                this.dialect.getTableFields(this.connection, dbf, cls);
                block12: for (FieldData fd : fds) {
                    for (String f : dbf) {
                        if (f.equals("do") || !fd.getField().getName().equals(f)) continue;
                        continue block12;
                    }
                    toAdd.add(fd);
                }
                if (toAdd.size() <= 0) continue;
                for (FieldData f : toAdd) {
                    Statement st = this.connection.createStatement();
                    Throwable throwable = null;
                    try {
                        st.execute("ALTER TABLE " + this.quote + cls + this.quote + " ADD " + this.quote + f.getField().getName() + this.quote + " " + this.dialect.getSqlType(f));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (st == null) continue;
                        if (throwable != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        st.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getTables(Connection conn) throws SQLException {
        ArrayList<String> arr = new ArrayList<String>();
        DatabaseMetaData md = conn.getMetaData();
        try (ResultSet rs = md.getTables(conn.getCatalog(), null, "%", null);){
            while (rs.next()) {
                arr.add(rs.getString(3));
            }
        }
        return arr.toArray(Mirror.emptyStringArray);
    }

    public static String[] getDatabases(Connection conn) throws SQLException {
        ArrayList<String> arr = new ArrayList<String>();
        try (ResultSet rs = conn.getMetaData().getCatalogs();){
            while (rs.next()) {
                arr.add(rs.getString(1));
            }
        }
        return arr.toArray(Mirror.emptyStringArray);
    }

    private void init() throws SQLException {
        String[] dbs;
        try {
            this.checkAndAddColumns();
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        for (String d : dbs = SqlStorage.getTables(this.connection)) {
            if (!baseDBName.equalsIgnoreCase(d)) continue;
            return;
        }
        try (Statement st = this.connection.createStatement();){
            st.execute("CREATE TABLE " + this.quote + baseDBName + this.quote + " (" + this.quote + "do" + this.quote + " " + this.dialect.getCreatePrimitiveKey(Integer.class, true, true, true, true) + "," + this.quote + "curId" + this.quote + " " + this.dialect.getCreatePrimitiveKey(Long.class, true, false, false, false) + ");");
            st.execute("INSERT INTO " + this.quote + baseDBName + this.quote + " VALUES (0,0);");
        }
    }

    protected static GenericStoreData.GenericStorageObjectState getState(GenericStorable gs) {
        GenericStoreData data = gs.getGenericStoreData();
        if (null == data) {
            return GenericStoreData.GenericStorageObjectState.NEW;
        }
        return data.getState();
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void buildQuery(StringBuilder sb, LogicalGroup lg) {
        block1 : switch (lg.getLogicalRelation()) {
            case and: 
            case or: {
                boolean nfirst = false;
                for (LogicalGroup g : lg.getLogicalGroups()) {
                    if (nfirst) {
                        sb.append(lg.getLogicalRelation() == LogicalRelation.and ? " AND " : " OR ");
                    }
                    sb.append("(");
                    this.buildQuery(sb, g);
                    sb.append(")");
                    nfirst = true;
                }
                break;
            }
            case unit: {
                AtomicCondition c = lg.getAtomicCondition();
                sb.append(this.quote);
                sb.append(c.getFieldName());
                sb.append(this.quote);
                switch (c.getOperator()) {
                    case contains: {
                        if (c.isNegated()) {
                            sb.append(" NOT");
                        }
                        sb.append(" LIKE ");
                        sb.append(this.strQuote);
                        sb.append("%");
                        String add = (String)c.getValue();
                        if (null == add) {
                            add = "null";
                        }
                        if (this.dialect instanceof MysqlDialect) {
                            add = add.replace("\\", "\\\\");
                        }
                        add = this.toQueryString(add);
                        sb.append(add);
                        sb.append("%");
                        sb.append(this.strQuote);
                        break block1;
                    }
                    case eq: {
                        if (c.getValue() == null) {
                            if (c.isNegated()) {
                                sb.append(" IS NOT NULL");
                                break block1;
                            }
                            sb.append(" IS NULL");
                            break block1;
                        }
                        sb.append(" ");
                        if (c.isNegated()) {
                            sb.append("!");
                        }
                        sb.append("= ");
                        if (c.getValue() instanceof String) {
                            sb.append(this.strQuote);
                            sb.append(this.toQueryString(c));
                            sb.append(this.strQuote);
                            break block1;
                        }
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case match: {
                        if (c.isNegated()) {
                            sb.append(" NOT");
                        }
                        sb.append(" REGEX ");
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case gt: {
                        if (c.isNegated()) {
                            sb.append(" < ");
                        } else {
                            sb.append(" >= ");
                        }
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case gte: {
                        if (c.isNegated()) {
                            sb.append(" <= ");
                        } else {
                            sb.append(" > ");
                        }
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case lt: {
                        if (c.isNegated()) {
                            sb.append(" > ");
                        } else {
                            sb.append(" <= ");
                        }
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case lte: {
                        if (c.isNegated()) {
                            sb.append(" >= ");
                        } else {
                            sb.append(" < ");
                        }
                        sb.append(this.toQueryString(c));
                        break block1;
                    }
                    case in: {
                        try {
                            Object val = c.getValue();
                            ArrayList<Object> it = null;
                            int length = -1;
                            if (val instanceof Collection) {
                                it = (ArrayList<Object>)val;
                                length = ((Collection)val).size();
                            } else if (val.getClass().isArray()) {
                                ArrayList<Object> ar = new ArrayList<Object>();
                                length = Array.getLength(val);
                                for (int i = 0; i < length; ++i) {
                                    ar.add(Array.get(val, i));
                                }
                                it = ar;
                            }
                            if (0 == length) {
                                if (c.isNegated()) {
                                    sb.append(" IS NOT NULL OR TRUE ");
                                    break block1;
                                }
                                sb.append(" IS NULL AND FALSE ");
                                break block1;
                            }
                            if (c.isNegated()) {
                                sb.append(" NOT IN ");
                            } else {
                                sb.append(" IN ");
                            }
                            JDBC.listing((Appendable)sb, it, this.formatValue);
                            break block1;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    protected String toQueryString(AtomicCondition ac) {
        return this.toQueryString(ac.getValue());
    }

    protected String toQueryString(Object o) {
        if (o instanceof GenericStorable) {
            return String.valueOf(GenericStorage.getID((GenericStorable)o));
        }
        if (o instanceof Date) {
            return String.valueOf(((Date)o).getTime());
        }
        if (null != o && o.getClass().isEnum()) {
            return String.valueOf(((Enum)o).ordinal());
        }
        return this.quote(o.toString());
    }

    protected String quote(String str) {
        return this.dialect.escapeString(str);
    }

    public static Class forName(String cls) {
        try {
            return Class.forName(cls);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class AutoCloseOnFinalizeRS
    implements Closeable {
        public ResultSet rs;
        public Statement st;

        public AutoCloseOnFinalizeRS(Statement st, ResultSet rs) {
            this.st = st;
            this.rs = rs;
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        @Override
        public void close() throws IOException {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

