/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database.JavaSQLImp;

import eu.javaexperience.io.SerializationTools;
import eu.javaexperience.text.Format;
import hu.ddsi.java.database.GenericStoreDataArray;
import hu.ddsi.java.database.GenericStoreDataReader;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.JavaSQLImp.SqlStorage;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;

public class SqlStorageReader
extends GenericStoreDataReader<SqlStorage.AutoCloseOnFinalizeRS> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object readField(String name, GenericStoreDataType type, SqlStorage.AutoCloseOnFinalizeRS rs) throws Exception {
        try {
            switch (type) {
                case Array: 
                case Serialized: {
                    String val = rs.rs.getString(name);
                    if (val == null) {
                        Object var5_15 = null;
                        return var5_15;
                    }
                    Serializable serializable = SerializationTools.deserializeFromBlob((byte[])Format.fromHex((String)val));
                    return serializable;
                }
                case Boolean: {
                    Boolean val = rs.rs.getBoolean(name);
                    return val;
                }
                case Byte: {
                    Byte val = rs.rs.getBytes(name)[0];
                    return val;
                }
                case Char: {
                    Character val = Character.valueOf(rs.rs.getString(name).charAt(0));
                    return val;
                }
                case Date: {
                    Date val = new Date(rs.rs.getLong(name));
                    return val;
                }
                case DontStore: {
                    Object val = null;
                    return val;
                }
                case Double: {
                    Double val = rs.rs.getDouble(name);
                    return val;
                }
                case Float: {
                    Float val = Float.valueOf(rs.rs.getFloat(name));
                    return val;
                }
                case Enum: 
                case Integer: {
                    Integer val = rs.rs.getInt(name);
                    return val;
                }
                case GenericDataId: {
                    long val = rs.rs.getLong(name);
                    if (val == 0L) {
                        Object var6_17 = null;
                        return var6_17;
                    }
                    Long l = val;
                    return l;
                }
                case Long: {
                    Long l = rs.rs.getLong(name);
                    return l;
                }
                case Short: {
                    Short s = rs.rs.getShort(name);
                    return s;
                }
                case String: {
                    String string = rs.rs.getString(name);
                    return string;
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs.rs.wasNull()) {
                return null;
            }
        }
    }

    @Override
    protected Object readSerializedField(String name, SqlStorage.AutoCloseOnFinalizeRS rs) throws Exception {
        String data = rs.rs.getString(name);
        if (null != data) {
            try {
                return SerializationTools.deserializeFromBlob((byte[])SqlStorageReader.stringToBlob(data));
            }
            catch (Exception e) {
                return SerializationTools.deserializeFromBlob((byte[])Format.fromHex((String)rs.rs.getString(name)));
            }
        }
        return null;
    }

    public static final byte[] stringToBlob(String adat) {
        if (adat.length() % 2 != 0) {
            throw new IllegalArgumentException("A String nem tartlmaz blob adatot!");
        }
        byte[] ki = new byte[adat.length() / 2];
        int pointer = 0;
        int strlen = adat.length();
        byte buf = 0;
        for (int i = 0; i < strlen; i += 2) {
            buf = (byte)SqlStorageReader.hexVal(adat.charAt(i));
            buf = (byte)(buf << 4);
            buf = (byte)(buf | (byte)SqlStorageReader.hexVal(adat.charAt(i + 1)));
            ki[pointer] = (byte)(buf - 128);
            ++pointer;
        }
        return ki;
    }

    private static final int hexVal(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return -1;
    }

    @Override
    protected Object[] readArray(String name, GenericStoreDataArray arr, SqlStorage.AutoCloseOnFinalizeRS rs) throws Exception {
        return (Object[])this.readSerializedField(name, rs);
    }

    @Override
    protected String getClassBy(SqlStorage.AutoCloseOnFinalizeRS cur) throws SQLException {
        return cur.rs.getMetaData().getTableName(1);
    }

    @Override
    protected long getIdBy(SqlStorage.AutoCloseOnFinalizeRS cur) throws SQLException {
        return cur.rs.getLong("do");
    }

    @Override
    protected boolean nextResult(SqlStorage.AutoCloseOnFinalizeRS cur) throws SQLException {
        return cur.rs.next();
    }

    @Override
    protected boolean setReadyToRead(SqlStorage.AutoCloseOnFinalizeRS cur) throws SQLException {
        return cur.rs.next();
    }
}

