/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.reflect.Mirror;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreMode;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreIgnore;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreNative;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreSerialized;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreStorableID;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GenericStorageMappingData {
    public final Class cls;
    public final FieldData[] allFd;
    public final FieldData[] storedFd;
    public static final FieldData[] emptyFDA = new FieldData[0];
    protected static Map<Class<? extends GenericStorable>, GenericStorageMappingData> classesFieldDatas = new ConcurrentHashMap<Class<? extends GenericStorable>, GenericStorageMappingData>();
    protected static Map<String, Class<?>> stringToClass;

    protected GenericStorageMappingData(Class cls, FieldData[] fds) {
        this.cls = cls;
        this.allFd = fds;
        ArrayList<FieldData> fs = new ArrayList<FieldData>();
        for (FieldData fd : fds) {
            if (!fd.isStored()) continue;
            fs.add(fd);
        }
        this.storedFd = fs.toArray(emptyFDA);
    }

    protected static boolean isNeedToStore(Field f) {
        return !Modifier.isStatic(f.getModifiers()) && !GenericStorageMappingData.dontStoreByAnnotation(f);
    }

    protected static boolean dontStoreByAnnotation(Field f) {
        Annotation[] anns = f.getAnnotations();
        if (null != anns) {
            for (Annotation a : anns) {
                if (a instanceof GenericStoreIgnore) {
                    return true;
                }
                if (a instanceof GenericStoreNative) {
                    return false;
                }
                if (a instanceof GenericStoreStorableID) {
                    return false;
                }
                if (!(a instanceof GenericStoreSerialized)) continue;
                return false;
            }
        }
        return false;
    }

    public static GenericStorageMappingData getOrCollectAllClassData(Class<? extends GenericStorable> cls) {
        GenericStorageMappingData ret = classesFieldDatas.get(cls);
        if (ret != null) {
            return ret;
        }
        GenericStorable instance = null;
        if (!cls.isInterface() && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                instance = GenericStorage.newInstance(cls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return GenericStorageMappingData.getOrCollectClassData(cls, instance);
    }

    protected static FieldData[] getOrCollectClassData(Class cls) throws InstantiationException, IllegalAccessException {
        return GenericStorageMappingData.getOrCollectAllClassData((Class<? extends GenericStorable>)cls).storedFd;
    }

    protected static GenericStorageMappingData getOrCollectClassData(Class cls, GenericStorable obj) {
        GenericStorageMappingData data;
        if (null != obj) {
            cls = obj.getClass();
        }
        if ((data = classesFieldDatas.get(cls)) != null) {
            return data;
        }
        ArrayList<FieldData> fds = new ArrayList<FieldData>();
        Map<String, GenericStoreMode> map = null;
        if (null != obj) {
            map = obj.getSelfDefinedMapping();
        }
        ArrayList tmp = new ArrayList();
        Mirror.collectClassFields(cls, tmp, (boolean)false);
        if (map != null) {
            GenericStoreMode def = map.get(null);
            if (def == null) {
                def = GenericStoreMode.GenericStoreDont;
            }
            for (Field f : tmp) {
                FieldData fd;
                if (Modifier.isStatic(f.getModifiers())) continue;
                GenericStoreMode mod = map.get(f.getName());
                if (!GenericStorageMappingData.isNeedToStore(f)) {
                    mod = GenericStoreMode.GenericStoreDont;
                }
                if (mod == null) {
                    mod = def;
                }
                if ((fd = new FieldData(f, mod)).getDataType() == null) continue;
                GenericStorageMappingData.addOverwrite(fd, fds);
            }
        } else {
            for (Field f : tmp) {
                FieldData fd;
                if (Modifier.isStatic(f.getModifiers()) || (fd = new FieldData(f)).getDataType() == null) continue;
                GenericStorageMappingData.addOverwrite(fd, fds);
            }
        }
        data = new GenericStorageMappingData(cls, fds.toArray(emptyFDA));
        classesFieldDatas.put(cls, data);
        stringToClass.put(cls.getName(), cls);
        return data;
    }

    protected static void addOverwrite(FieldData data, ArrayList<FieldData> fds) {
        String name = data.f.getName();
        for (int i = 0; i < fds.size(); ++i) {
            FieldData d = fds.get(i);
            if (!d.f.getName().equals(name)) continue;
            return;
        }
        fds.add(data);
    }

    static {
        classesFieldDatas.put(GenericStorable.class, new GenericStorageMappingData(GenericStorable.class, emptyFDA));
        stringToClass = new HashMap();
    }
}

