/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.reflect.Mirror;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStoreDataReader;
import hu.ddsi.java.database.GenericStoreDataWriter;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreQueryResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionWrappedGdb
extends GenericStoreDatabase {
    protected GenericStoreDatabase gdb;
    protected SimpleGet<Set<String>> permissions;

    public PermissionWrappedGdb(GenericStoreDatabase gdb, SimpleGet<Set<String>> perms) {
        this.gdb = gdb;
        this.permissions = perms;
        try {
            this.mustCallAfterConnectionEstablishedBeforeUse();
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
    }

    public GenericStoreDatabase getBackend() {
        return this.gdb;
    }

    @Override
    protected void resolvePlacements() throws IOException, Exception {
        this.gdb.resolvePlacements();
    }

    @Override
    protected GenericStorable getFromCacheOrPublishRead(long id, Object res, Class<GenericStorable> re, String cls, FieldData[] fds) throws Exception {
        return this.gdb.getFromCacheOrPublishRead(id, res, re, cls, fds);
    }

    @Override
    protected void setupReadedObject(GenericStorable gs, long id) {
        this.gdb.setupReadedObject(gs, id);
    }

    @Override
    protected GenericStorable getSingleObjectByID(long id, List<Class<? extends GenericStorable>> clss) throws Exception {
        return this.gdb.getSingleObjectByID(id, clss);
    }

    @Override
    public List<Class<? extends GenericStorable>> getDescendantClassesFor(Class<? extends GenericStorable> cls) throws Exception {
        return this.gdb.getDescendantClassesFor(cls);
    }

    @Override
    public boolean isStored(Class<? extends GenericStorable> cls) throws Exception {
        return this.gdb.isStored(cls);
    }

    @Override
    protected boolean isStored(Class<? extends GenericStorable> cls, String[] lst) {
        return this.gdb.isStored(cls, lst);
    }

    @Override
    public GenericStoreDataWriter getWriter(String cls) throws Exception {
        return this.gdb.getWriter(cls);
    }

    @Override
    public String getDatabaseName() {
        return this.gdb.getDatabaseName();
    }

    protected void assertPermission(String perm) {
        if (!((Set)this.permissions.get()).contains(perm)) {
            throw new RuntimeException("You have no `" + perm + "` permission for this database");
        }
    }

    @Override
    public GenericStoreQueryResult getIDListByQuery(Class<? extends GenericStorable> cls, LogicalGroup lg, boolean all_field) throws Exception {
        this.assertPermission("read");
        return this.gdb.getIDListByQuery(cls, lg, all_field);
    }

    @Override
    public void createStorageForClass(Class<? extends GenericStorable> cls, FieldData[] data) throws Exception {
        this.assertPermission("write");
        this.gdb.createStorageForClass(cls, data);
    }

    @Override
    protected void dropClassStorageImpl(Class<? extends GenericStorable> cls) throws Exception {
        this.assertPermission("delete");
        this.gdb.dropClassStorage(cls);
    }

    @Override
    public void deleteObjectByIDSByClass(long[] id, Class<? extends GenericStorable>[] cls) throws Exception {
        this.assertPermission("delete");
        this.gdb.deleteObjectByIDSByClass(id, cls);
    }

    @Override
    public String[] listStoredClasses() throws Exception {
        this.assertPermission("read");
        return this.gdb.listStoredClasses();
    }

    @Override
    public GenericStoreDataReader getReader(String clas) throws Exception {
        return this.gdb.getReader(clas);
    }

    @Override
    public void storeAll(Map<Class<? extends GenericStorable>, List<? extends GenericStorable>> map) throws Exception {
        this.assertPermission("write");
        this.gdb.storeAll(map);
    }

    @Override
    protected List<Long> reserveNextIDRangeAtomic(int size) throws Exception {
        this.assertPermission("create");
        return this.gdb.reserveNextIDRangeAtomic(size);
    }

    @Override
    protected long getCurrentId() throws Exception {
        return this.gdb.getCurrentId();
    }

    @Override
    public void close() {
        this.gdb.close();
    }
}

