/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.collection.set.OneShotList;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.SimpleGetFactory;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetByTools;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.math.MathTools;
import eu.javaexperience.query.F;
import eu.javaexperience.query.LogicalGroup;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDataReader;
import hu.ddsi.java.database.GenericStoreDataType;
import hu.ddsi.java.database.GenericStoreDataWriter;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GenericStoreMode;
import hu.ddsi.java.database.GenericStoreQueryResult;
import hu.ddsi.java.database.GsdbExtraCaluse;
import hu.ddsi.java.database.GsdbModelPlacementRequests;
import hu.ddsi.java.database.Limit;
import hu.ddsi.java.database.Offset;
import hu.ddsi.java.database.OrderBy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GenericStoreDatabase
implements Closeable,
ExternalDataAttached {
    protected static final boolean USE_BULK_LOAD = true;
    protected Map<Long, Reference<GenericStorable>> cache = new ConcurrentHashMap<Long, Reference<GenericStorable>>();
    protected long modificationCount = 0L;
    protected long lastId = 0L;
    protected static final GetBy1<Map<Long, GsdbModelPlacementRequests>, Class> CREATE_MAP = GetByTools.wrapSimpleGet((SimpleGet)SimpleGetFactory.getHashMapFactory());
    protected Map<Class, Map<Long, GsdbModelPlacementRequests>> bulkPlacementRequests = new HashMap<Class, Map<Long, GsdbModelPlacementRequests>>();
    protected MultiMap<Class<? extends GenericStorable>, Class<? extends GenericStorable>> storedClasses = null;
    public static final GenericStorable NULL_VALUE = new GenericStorable(){

        @Override
        public void setGenericStoreData(GenericStoreData data) {
        }

        @Override
        public Map<String, GenericStoreMode> getSelfDefinedMapping() {
            return null;
        }

        @Override
        public GenericStoreData getGenericStoreData() {
            return null;
        }

        @Override
        public void beforeStored(GenericStoreDatabase db) {
        }

        @Override
        public void afterRestored(GenericStoreDatabase db) {
        }
    };
    protected transient Map<String, Object> extraData;

    public long getModificationCount() {
        return this.modificationCount;
    }

    void putPlacementRequest(Class c, long id, SimplePublish1<GenericStorable> placer) throws Exception {
        GenericStorable gs;
        Reference<GenericStorable> p = this.cache.get(id);
        if (null != p && null != (gs = p.get())) {
            if (NULL_VALUE == gs) {
                gs = null;
            }
            placer.publish((Object)gs);
            return;
        }
        Map add = (Map)MapTools.getOrCreate(this.bulkPlacementRequests, (Object)c, CREATE_MAP);
        GsdbModelPlacementRequests append = (GsdbModelPlacementRequests)add.get(id);
        if (null == append) {
            append = new GsdbModelPlacementRequests(c, id);
            add.put(id, append);
        }
        append.placers.add(placer);
    }

    protected void resolvePlacements() throws IOException, Exception {
        if (this.bulkPlacementRequests.isEmpty()) {
            return;
        }
        BulkTransitMap reqs = new BulkTransitMap();
        reqs.putAll(this.bulkPlacementRequests);
        this.bulkPlacementRequests.clear();
        ArrayList tmp = new ArrayList();
        for (Map.Entry kv : reqs.entrySet()) {
            Map ids = (Map)kv.getValue();
            this.getAllObjectsByQuery((Class)kv.getKey(), F.in.is("do", ids.keySet()), tmp, new GsdbExtraCaluse[0]);
            for (GenericStorable t : tmp) {
                long id = GenericStorage.getID(t);
                GsdbModelPlacementRequests req = (GsdbModelPlacementRequests)ids.get(id);
                if (null == req) continue;
                for (SimplePublish1<GenericStorable> p : req.placers) {
                    p.publish((Object)t);
                }
            }
        }
        this.resolvePlacements();
    }

    public static FieldData[] getOrCreateFieldData(Class<? extends GenericStorable> cls) throws InstantiationException, IllegalAccessException {
        return GenericStorage.getOrCollectClassData(cls);
    }

    protected static Reference<GenericStorable> refObject(GenericStorable gs) {
        return new HardReference<GenericStorable>(gs);
    }

    protected GenericStorable getFromCacheOrPublishRead(long id, Object res, Class<GenericStorable> re, String cls, FieldData[] fds) throws Exception {
        Reference<GenericStorable> ref = this.cache.get(id);
        GenericStorable ret = null;
        if (ref != null) {
            ret = ref.get();
            if (ret == NULL_VALUE) {
                return null;
            }
            if (ret != null) {
                return ret;
            }
        }
        ret = GenericStorage.newInstance(re);
        try {
            ref = GenericStoreDatabase.refObject(ret);
            this.cache.put(id, ref);
            this.setupReadedObject(ret, id);
            ret = this.getReader(cls).readObject(id, res, ret, this, fds);
            if (ret != null) {
                ret.afterRestored(this);
            } else {
                ret = NULL_VALUE;
            }
            return ret;
        }
        catch (Exception e) {
            this.cache.remove(id);
            throw e;
        }
    }

    protected GenericStorable _getFromCacheOrPublishRead(long id, Object res, GenericStorable re, String cls, FieldData[] fds) throws Exception {
        Reference<GenericStorable> ref = this.cache.get(id);
        GenericStorable ret = null;
        if (ref != null) {
            ret = ref.get();
            if (ret == NULL_VALUE) {
                return null;
            }
            if (ret != null) {
                return ret;
            }
        }
        this.cache.put(id, GenericStoreDatabase.refObject(re));
        try {
            this.setupReadedObject(re, id);
            ret = this.getReader(cls).readObject(id, res, re, this, fds);
            if (ret != null) {
                ret.afterRestored(this);
            }
            return ret;
        }
        catch (Exception e) {
            this.cache.remove(id);
            throw e;
        }
    }

    protected void setupReadedObject(GenericStorable gs, long id) {
        GenericStoreData dat = new GenericStoreData();
        dat.id = id;
        dat.state = GenericStoreData.GenericStorageObjectState.PERSISTED;
        dat.owner = this;
        gs.setGenericStoreData(dat);
    }

    protected GenericStorable getSingleObjectByID(long id, List<Class<? extends GenericStorable>> clss) throws Exception {
        GenericStorable ret;
        Reference<GenericStorable> ref = this.cache.get(id);
        GenericStorable genericStorable = ret = ref == null ? null : ref.get();
        if (NULL_VALUE == ret) {
            return null;
        }
        if (ret == null) {
            for (Class<? extends GenericStorable> c : clss) {
                try (GenericStoreQueryResult res = this.getIDListByQuery(c, F.eq.is("do", (Object)id), true);){
                    if (res == null) continue;
                    GenericStoreDataReader reader = this.getReader(c.getName());
                    for (GenericStoreQueryResult.ResultUnit ru : res.getResults()) {
                        Object re = ru.getCursor();
                        if (!reader.setReadyToRead(re)) continue;
                        ret = GenericStorage.newInstance(c);
                        this.cache.put(id, GenericStoreDatabase.refObject(ret));
                        try {
                            this.setupReadedObject(ret, id);
                            ret = reader.readObject(id, re, ret, this, GenericStorage.getOrCollectClassData(c));
                            if (ret != null) {
                                ret.afterRestored(this);
                            }
                            GenericStorable genericStorable2 = ret;
                            return genericStorable2;
                        }
                        catch (Exception e) {
                            this.cache.remove(id);
                            throw e;
                        }
                    }
                }
            }
        }
        if (null == ret) {
            this.cache.put(id, GenericStoreDatabase.refObject(NULL_VALUE));
        }
        this.resolvePlacements();
        return ret;
    }

    public List<Class<? extends GenericStorable>> getDescendantClassesFor(Class<? extends GenericStorable> cls) throws Exception {
        List ret = this.storedClasses.getList(cls);
        if (null == ret) {
            return NullList.instance;
        }
        return Collections.unmodifiableList(ret);
    }

    public void mustCallAfterConnectionEstablishedBeforeUse() throws GenericStoreException {
        try {
            this.resfreshStoredClassesRegister();
            this.lastId = this.getCurrentId();
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
    }

    public boolean isStored(Class<? extends GenericStorable> cls) throws Exception {
        String c = cls.getName();
        if (this.storedClasses.containsKey(cls)) {
            return true;
        }
        for (String s : this.listStoredClasses()) {
            if (!c.equals(s)) continue;
            return true;
        }
        return false;
    }

    protected boolean isStored(Class<? extends GenericStorable> cls, String[] lst) {
        String n = cls.getName();
        for (String s : lst) {
            if (!s.equals(n)) continue;
            return true;
        }
        return false;
    }

    protected synchronized void recursiveIntoMapIfStored(Class<? extends GenericStorable> rootcls, Class<? extends GenericStorable> curr, String[] storeds, MultiMap<Class<? extends GenericStorable>, Class<? extends GenericStorable>> map, ClassLoader ctxcldr) {
        if (rootcls.isInterface() || Modifier.isAbstract(rootcls.getModifiers())) {
            return;
        }
        map.put(curr, rootcls);
        if (curr.equals(GenericStorable.class)) {
            return;
        }
        Class<? extends GenericStorable> c = curr.getSuperclass();
        if (c != null && GenericStorable.class.isAssignableFrom(c)) {
            this.recursiveIntoMapIfStored(rootcls, c, storeds, map, ctxcldr);
        }
        for (Class<?> c2 : curr.getInterfaces()) {
            if (!GenericStorable.class.isAssignableFrom(c2)) continue;
            this.recursiveIntoMapIfStored(rootcls, c2, storeds, map, ctxcldr);
        }
    }

    public abstract GenericStoreDataWriter getWriter(String var1) throws Exception;

    public abstract String getDatabaseName();

    public abstract GenericStoreQueryResult getIDListByQuery(Class<? extends GenericStorable> var1, LogicalGroup var2, boolean var3) throws Exception;

    public abstract void createStorageForClass(Class<? extends GenericStorable> var1, FieldData[] var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStorageForClassIfNeeded(Class<? extends GenericStorable> cls, FieldData[] data) throws Exception {
        String[] clss = this.listStoredClasses();
        MultiMap<Class<? extends GenericStorable>, Class<? extends GenericStorable>> multiMap = this.storedClasses;
        synchronized (multiMap) {
            if (this.isStored(cls, clss)) {
                return;
            }
            this.createStorageForClass(cls, data);
            this.resfreshStoredClassesRegister();
        }
    }

    public void dropClassStorage(Class<? extends GenericStorable> cls) throws Exception {
        ++this.modificationCount;
        this.dropClassStorageImpl(cls);
        this.resfreshStoredClassesRegister();
    }

    protected abstract void dropClassStorageImpl(Class<? extends GenericStorable> var1) throws Exception;

    public abstract void deleteObjectByIDSByClass(long[] var1, Class<? extends GenericStorable>[] var2) throws Exception;

    public abstract String[] listStoredClasses() throws Exception;

    public abstract GenericStoreDataReader getReader(String var1) throws Exception;

    public void resfreshStoredClassesRegister() throws Exception {
        this.storedClasses = new MultiMap();
        String[] storeds = this.listStoredClasses();
        HashMap clsMap = new HashMap();
        ClassLoader clsldr = Thread.currentThread().getContextClassLoader();
        for (String strcls : storeds) {
            try {
                Class<?> cls = clsldr.loadClass(strcls);
                if (!this.isStored(cls, storeds)) continue;
                this.recursiveIntoMapIfStored(cls, cls, storeds, this.storedClasses, clsldr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fillResults(Collection coll, GenericStoreQueryResult.ResultUnit result) throws Exception {
        Object rs = result.getCursor();
        Class<GenericStorable> cls = Thread.currentThread().getContextClassLoader().loadClass(result.getReturnClass());
        FieldData[] fds = GenericStoreDatabase.getOrCreateFieldData(cls);
        GenericStoreDataReader reader = this.getReader(result.getReturnClass());
        while (reader.nextResult(rs)) {
            GenericStorable add = this.getFromCacheOrPublishRead(reader.getIdBy(rs), rs, cls, result.getReturnClass(), fds);
            if (null == add) continue;
            coll.add(add);
        }
        this.resolvePlacements();
    }

    protected static Set<? extends GenericStorable> extract(Collection<? extends GenericStorable> src) throws InstantiationException, IllegalAccessException {
        HashSet<GenericStorable> ret = new HashSet<GenericStorable>();
        for (GenericStorable genericStorable : src) {
            GenericStoreDatabase.extractInto(ret, genericStorable);
        }
        return ret;
    }

    protected static void extractInto(Set<GenericStorable> dst, GenericStorable gs) throws InstantiationException, IllegalAccessException {
        if (GenericStoreDatabase.isNeedToStoreReal(gs) && dst.add(gs)) {
            FieldData[] fd;
            for (FieldData f : fd = GenericStoreDatabase.getOrCreateFieldData(gs.getClass())) {
                Object[] os;
                if (GenericStoreDataType.GenericDataId == f.type) {
                    Object o = f.f.get(gs);
                    if (!(o instanceof GenericStorable)) continue;
                    GenericStoreDatabase.extractInto(dst, (GenericStorable)o);
                    continue;
                }
                if (GenericStoreDataType.Array != f.type || null == (os = (Object[])f.f.get(gs))) continue;
                for (Object o : os) {
                    if (!(o instanceof GenericStorable)) continue;
                    GenericStoreDatabase.extractInto(dst, (GenericStorable)o);
                }
            }
        }
    }

    public static boolean isNeedToStoreReal(GenericStorable gs) {
        if (null != gs) {
            GenericStoreData data = gs.getGenericStoreData();
            if (null == data) {
                return true;
            }
            if (gs.getGenericStoreData().id == -1L || GenericStoreData.GenericStorageObjectState.UNDER_SAVE != data.state && gs.getGenericStoreData().isModified()) {
                return true;
            }
        }
        return false;
    }

    public void storeAll(Collection<? extends GenericStorable> _coll) throws Exception {
        Set<? extends GenericStorable> coll = GenericStoreDatabase.extract(_coll);
        SmallMap map = new SmallMap();
        int numz = 0;
        for (GenericStorable genericStorable : coll) {
            genericStorable.beforeStored(this);
            ((List)MapTools.ensureKey((Map)map, genericStorable.getClass(), (SimpleGet)SimpleGetFactory.getArrayListFactory())).add(genericStorable);
            if (GenericStorage.getID(genericStorable) != -1L) continue;
            ++numz;
        }
        ++this.modificationCount;
        for (GenericStorable genericStorable : coll) {
            this.getOrCreateGenericStoreData((GenericStorable)genericStorable).state = GenericStoreData.GenericStorageObjectState.UNDER_SAVE;
        }
        try {
            List<Long> ids = this.reserveNextIDRangeAtomic(numz);
            numz = 0;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (GenericStorable genericStorable : coll) {
                if (GenericStorage.getID(genericStorable) != -1L) continue;
                GenericStoreData data = GenericStorage.getOrCreateGenericStoreData(genericStorable);
                data.setOwnerDatabase(this);
                long id = ids.get(numz++);
                arrayList.add(id);
                data.setId(id);
                this.cache.put(id, GenericStoreDatabase.refObject(genericStorable));
            }
            try {
                this.storeAll((Map<Class<? extends GenericStorable>, List<? extends GenericStorable>>)map);
            }
            catch (Exception exception) {
                for (Long i : arrayList) {
                    this.cache.remove(i);
                }
                throw exception;
            }
        }
        catch (Exception e) {
            for (GenericStorable genericStorable : coll) {
                genericStorable.getGenericStoreData().state = GenericStoreData.GenericStorageObjectState.MODIFIED;
            }
            throw e;
        }
        for (GenericStorable genericStorable : coll) {
            genericStorable.getGenericStoreData().state = GenericStoreData.GenericStorageObjectState.PERSISTED;
        }
    }

    protected static <T> T getOfType(Object[] os, Class<T> c) {
        for (Object o : os) {
            if (!c.isAssignableFrom(o.getClass())) continue;
            return (T)o;
        }
        return null;
    }

    protected <T extends GenericStorable> void getAllObjectsByQuery(Class<? extends T> cls, LogicalGroup lg, Collection<T> coll, GsdbExtraCaluse ... extra) throws Exception {
        int end;
        Comparator<GenericStorable> cmp;
        Collection<T> collection;
        ArrayList<T> tmp = null;
        if (null == extra || extra.length == 0) {
            collection = coll;
        } else {
            tmp = new ArrayList<T>();
            collection = tmp;
        }
        Collection<T> dst = collection;
        for (Class<? extends GenericStorable> c : this.getDescendantClassesFor(cls)) {
            if (!this.isStored(c)) {
                return;
            }
            GenericStoreQueryResult res = this.getIDListByQuery(c, lg, true);
            try {
                for (GenericStoreQueryResult.ResultUnit u : res.getResults()) {
                    this.fillResults(dst, u);
                }
            }
            finally {
                if (res == null) continue;
                res.close();
            }
        }
        this.resolvePlacements();
        if (null == tmp) {
            return;
        }
        OrderBy ob = GenericStoreDatabase.getOfType(extra, OrderBy.class);
        Limit l = GenericStoreDatabase.getOfType(extra, Limit.class);
        Offset o = GenericStoreDatabase.getOfType(extra, Offset.class);
        if (null != ob && null != (cmp = ob.createComparator(cls))) {
            Collections.sort(tmp, cmp);
        }
        int off = 0;
        int limit = Integer.MAX_VALUE;
        if (null != o) {
            off = o.offset;
        }
        if (null != l) {
            limit = l.limit;
        }
        if ((end = off + limit) > tmp.size()) {
            end = tmp.size();
        }
        for (int i = off; i < end; ++i) {
            coll.add((GenericStorable)tmp.get(i));
        }
    }

    protected GenericStoreData getOrCreateGenericStoreData(GenericStorable gs) {
        GenericStoreData ret = gs.getGenericStoreData();
        if (null == ret) {
            ret = new GenericStoreData();
            gs.setGenericStoreData(ret);
            ret.id = -1L;
            ret.state = GenericStoreData.GenericStorageObjectState.NEW;
            ret.owner = this;
        }
        return ret;
    }

    protected void store(GenericStorable gs) throws Exception {
        this.storeAll((Collection<? extends GenericStorable>)new OneShotList((Object)gs));
    }

    protected abstract void storeAll(Map<Class<? extends GenericStorable>, List<? extends GenericStorable>> var1) throws Exception;

    protected abstract List<Long> reserveNextIDRangeAtomic(int var1) throws Exception;

    public List<Long> assignNextIdRange(int size) throws Exception {
        List<Long> ret = this.reserveNextIDRangeAtomic(size);
        Long max = MathTools.getMaxLong(ret);
        if (null != max && max > this.lastId) {
            this.lastId = max;
        }
        return ret;
    }

    protected abstract long getCurrentId() throws Exception;

    @Override
    public abstract void close();

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap();
        }
        return this.extraData;
    }

    public static class HardReference<T>
    extends SoftReference<T> {
        final T obj;

        public HardReference(T referent) {
            super(referent);
            this.obj = referent;
        }
    }
}

