/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.query.F;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.reflect.Mirror;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorageMappingData;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GsdbExtraCaluse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericStorage {
    public static final long ObjectUntrackedUnstored = -2L;
    public static final long NewObjectNotSaved = -1L;

    public static FieldData getFieldByName(FieldData[] data, String name) {
        for (FieldData d : data) {
            if (!d.f.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public static FieldData[] getOrCollectClassDataRt(Class<? extends GenericStorable> cls) {
        try {
            return GenericStorage.getOrCollectClassData(cls);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static FieldData[] getOrCollectClassData(Class<? extends GenericStorable> cls) throws InstantiationException, IllegalAccessException {
        return GenericStorageMappingData.getOrCollectClassData(cls);
    }

    public static <T extends GenericStorable> T newInstance(Class<T> cls) throws InstantiationException, IllegalAccessException {
        return (T)((GenericStorable)cls.newInstance());
    }

    @Deprecated
    public static GenericStorable getObjectByID(long id, GenericStoreDatabase gdb) throws GenericStoreException {
        return GenericStorage.getObjectByIDDescendantOf(id, GenericStorable.class, gdb);
    }

    public static <T extends GenericStorable> T getObjectByIDDescendantOf(long id, Class<? extends T> cls, GenericStoreDatabase gdb) throws GenericStoreException {
        try {
            return (T)gdb.getSingleObjectByID(id, gdb.getDescendantClassesFor(cls));
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
    }

    public static <D extends GenericStoreDatabase, W> void storeObject(GenericStorable gs, D gdb) throws GenericStoreException {
        GenericStoreData data = gs.getGenericStoreData();
        if (!(data == null || gs.getGenericStoreData().id == -1L || GenericStoreData.GenericStorageObjectState.UNDER_SAVE != data.state && gs.getGenericStoreData().isModified())) {
            return;
        }
        try {
            gdb.store(gs);
        }
        catch (Exception e) {
            throw new GenericStoreException(e.getMessage() + " " + gs.toString(), e);
        }
    }

    public static GenericStoreData getOrCreateGenericStoreData(GenericStorable gs) {
        GenericStoreData data = gs.getGenericStoreData();
        if (data == null) {
            data = new GenericStoreData();
            gs.setGenericStoreData(data);
        }
        return data;
    }

    public static void storeAll(Collection<? extends GenericStorable> coll, GenericStoreDatabase gdb) throws GenericStoreException {
        try {
            gdb.storeAll(coll);
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
    }

    public static void storeAll(GenericStoreDatabase gdb, GenericStorable ... gss) throws GenericStoreException {
        try {
            gdb.storeAll(CollectionTools.inlineAdd(new ArrayList(), (Object[])gss));
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
    }

    public static <T extends GenericStorable> void getAllObjectsByQuery(Class<? extends T> cls, LogicalGroup lg, Collection<T> coll, GenericStoreDatabase gdb, GsdbExtraCaluse ... extra) throws GenericStoreException {
        try {
            gdb.getAllObjectsByQuery(cls, lg, coll, extra);
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
    }

    public static void removeObject(GenericStorable gd, GenericStoreDatabase gdb) throws GenericStoreException {
        GenericStoreData data = gd.getGenericStoreData();
        if (data == null) {
            return;
        }
        if (data.id < 0L) {
            return;
        }
        try {
            gdb.deleteObjectByIDSByClass(new long[]{data.id}, new Class[]{gd.getClass()});
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
        GenericStorage.untraceObject(gd);
    }

    public static <A extends Collection<B>, B extends GenericStorable> void bulkRemoveObject(A gs, GenericStoreDatabase gdb) throws GenericStoreException {
        HashMap map = new HashMap();
        for (GenericStorable genericStorable : gs) {
            GenericStoreData data;
            if (genericStorable == null || (data = genericStorable.getGenericStoreData()) == null || data.id < 0L) continue;
            ArrayList<GenericStorable> c = (ArrayList<GenericStorable>)map.get(genericStorable.getClass());
            if (c == null) {
                c = new ArrayList<GenericStorable>();
                map.put(genericStorable.getClass(), c);
            }
            c.add(genericStorable);
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                List l = (List)entry.getValue();
                long[] idz = new long[l.size()];
                for (int i = 0; i < idz.length; ++i) {
                    idz[i] = GenericStorage.getID((GenericStorable)l.get(i));
                }
                gdb.deleteObjectByIDSByClass(idz, new Class[]{(Class)entry.getKey()});
            }
        }
        catch (Exception e) {
            throw new GenericStoreException(e);
        }
        for (GenericStorable genericStorable : gs) {
            if (genericStorable == null) continue;
            GenericStorage.untraceObject(genericStorable);
        }
    }

    public static long getID(GenericStorable gs) {
        return gs.getGenericStoreData() == null ? -1L : gs.getGenericStoreData().id;
    }

    public static boolean isStored(GenericStorable gs) {
        GenericStoreData data = gs.getGenericStoreData();
        return data != null && data.owner != null && data.id > 0L;
    }

    public static GenericStoreDatabase getOwnerDatabase(GenericStorable gs) {
        return gs.getGenericStoreData() == null ? null : gs.getGenericStoreData().owner;
    }

    public static void objectModified(GenericStorable st) {
        if (st.getGenericStoreData() != null) {
            st.getGenericStoreData().state = GenericStoreData.GenericStorageObjectState.MODIFIED;
        }
    }

    public static void untraceObject(GenericStorable gs) {
        gs.getGenericStoreData().id = -2L;
        gs.getGenericStoreData().owner = null;
        gs.getGenericStoreData().state = GenericStoreData.GenericStorageObjectState.DELETED;
    }

    public static void fillFieldData(Class<? extends GenericStorable> type, Collection<FieldData> dst) throws InstantiationException, IllegalAccessException {
        FieldData[] fds = GenericStorage.getOrCollectClassData(type);
        if (null != fds) {
            for (FieldData f : fds) {
                dst.add(f);
            }
        }
    }

    public static <T extends GenericStorable> void post(GenericStoreDatabase gdb, T j) throws GenericStoreException {
        GenericStoreDatabase odb = GenericStorage.getOwnerDatabase(j);
        if (null != odb && !odb.equals(gdb)) {
            throw new RuntimeException("Object from different database");
        }
        if (GenericStorage.isStored(j)) {
            GenericStorage.objectModified(j);
        }
        GenericStorage.storeObject(j, gdb);
    }

    public static <C extends Collection<GenericStorable>> C getReferences(GenericStorable subject, C refs) throws Exception {
        Class<?> scls = subject.getClass();
        GenericStoreDatabase gdb = GenericStorage.getOwnerDatabase(subject);
        List<Class<? extends GenericStorable>> classes = gdb.getDescendantClassesFor(GenericStorable.class);
        for (Class<? extends GenericStorable> c : classes) {
            FieldData[] fs;
            if (c == GenericStorable.class) continue;
            for (FieldData f : fs = GenericStoreDatabase.getOrCreateFieldData(c)) {
                if (!scls.isAssignableFrom(f.f.getType())) continue;
                GenericStorage.getAllObjectsByQuery(c, F.eq.is(f.f.getName(), (Object)subject), refs, gdb, new GsdbExtraCaluse[0]);
            }
        }
        return refs;
    }

    public static <T extends GenericStorable> List<T> getObjectsByQuery(Class<T> class1, LogicalGroup lg, GenericStoreDatabase gdb) throws GenericStoreException {
        ArrayList ret = new ArrayList();
        GenericStorage.getAllObjectsByQuery(class1, lg, ret, gdb, new GsdbExtraCaluse[0]);
        return ret;
    }

    public static <T extends GenericStorable> long[] getIds(Collection<T> objects) {
        long[] ret = new long[objects.size()];
        int i = 0;
        for (GenericStorable o : objects) {
            ret[i++] = GenericStorage.getID(o);
        }
        return ret;
    }

    public static <T extends GenericStorable> void postAll(GenericStoreDatabase gdb, Collection<T> els) throws GenericStoreException {
        for (GenericStorable e : els) {
            if (!GenericStorage.isStored(e)) continue;
            GenericStorage.objectModified(e);
        }
        GenericStorage.storeAll(els, gdb);
    }

    public static <T extends GenericStorable> void getObjectsByQuery(GenericStoreDatabase gdb, Collection<T> ents, Class<T> cls, LogicalGroup lg, GsdbExtraCaluse ... extra) throws GenericStoreException {
        GenericStorage.getAllObjectsByQuery(cls, lg, ents, gdb, extra);
    }

    public static void update(GenericStorable elem) throws GenericStoreException {
        GenericStoreDatabase gdb = GenericStorage.getOwnerDatabase(elem);
        if (null == gdb) {
            throw new RuntimeException("Object not yet stored, can't update");
        }
        GenericStorage.post(gdb, elem);
    }
}

