/*
 * Decompiled with CFR 0.152.
 */
package hu.ddsi.java.database;

import eu.javaexperience.collection.ComparatorTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GsdbExtraCaluse;
import hu.ddsi.java.database.GsdbExtraClauseType;
import java.lang.reflect.Field;
import java.util.Comparator;

public class OrderBy
implements GsdbExtraCaluse {
    public final boolean asc;
    public final String field;
    public static final Comparator<GenericStorable> COMPARATOR_FOR_GS = (a, b) -> ComparatorTools.COMPARATOR_FOR_LONG.compare(GenericStorage.getID(a), GenericStorage.getID(b));

    @Override
    public GsdbExtraClauseType getType() {
        return GsdbExtraCaluse.WellKnownGsdbExtraCaluses.order;
    }

    public OrderBy() {
        this(null, false);
    }

    public OrderBy(String field, boolean asc) {
        this.field = field;
        this.asc = asc;
    }

    public static OrderBy asc(String field) {
        return new OrderBy(field, true);
    }

    public static OrderBy desc(String field) {
        return new OrderBy(field, false);
    }

    protected static Object examine(Field f, Object subject) {
        if (null == subject) {
            return null;
        }
        try {
            return f.get(subject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Comparator<GenericStorable> createComparator(Class c) throws InstantiationException, IllegalAccessException {
        FieldData fd = GenericStorage.getFieldByName(GenericStorage.getOrCollectClassData(c), this.field);
        if (null == fd) {
            throw new RuntimeException("No field `" + this.field + "` in class: " + c.getName());
        }
        final Field f = fd.f;
        Class<?> type = f.getType();
        Comparator cmp = null;
        cmp = type.isEnum() ? ComparatorTools.COMPARATOR_FOR_ENUM : (Comparator.class.isAssignableFrom(c) ? (Comparator)c.newInstance() : (GenericStorable.class.isAssignableFrom(type) ? COMPARATOR_FOR_GS : ComparatorTools.getComparatorByClass(type)));
        if (null == cmp) {
            cmp = ComparatorTools.COMPARATOR_FOR_OBJECT_HASH;
        }
        Comparator ret = ComparatorTools.createFieldComparatorWithNulls((GetBy1)new GetBy1<Object, GenericStorable>(){

            public Object getBy(GenericStorable a) {
                return OrderBy.examine(f, a);
            }
        }, (Comparator)cmp, (boolean)true);
        if (!this.asc) {
            return ComparatorTools.reverseOrder((Comparator)ret);
        }
        return ret;
    }
}

