package eu.javaexperience.web;

import java.io.OutputStream;
import java.util.Map;

import org.jsoup.nodes.Element;

import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.jsoup.JsoupTools;
import eu.javaexperience.web.TemplateWebsiteTools.TemplateWebsiteTemplateDetails;
import eu.javaexperience.web.template.TemplateManager;
import eu.javaexperience.web.template.TemplateManagerTools;
import eu.javaexperience.web.template.jsoup.JsoupTemplateManager;

public class JsoupTemplateWebsite
{
	public static TemplateWebsiteServer createTemplateServer
	(
		Dispatcher<Context> dispatcher,
		final SimpleGet<IOStreamServer<IOStream>> serverSocketCreator,
		final TemplateWebsiteDefaultAsset assets,
		final AbstractFile TEMPLATE_ROOT
	)
	{
		return TemplateWebsiteTools.createTemplateServer(dispatcher, serverSocketCreator, assets, TEMPLATE_ROOT, new TemplateWebsiteTemplateDetails()
		{
			@Override
			public void initRequest(Context ctx)
			{
				JsoupTools.addTemplateWebsiteDefaultDomGetter("public_root", new SimplePublish1<Element>()
				{
					@Override
					public void publish(Element a)
					{
						Map<String, Object> env = ctx.getEnv();
						
						JsoupTools.addClientFramework
						(
							assets.cdnFrameworks
						);
						
						JsoupTools.linkPreJs
						(
							assets.preJsUrls
						);
						
						JsoupTools.linkCss
						(
							assets.cssUrls
						);
						
						JsoupTools.linkPostJs
						(
							assets.postJsUrls
						);
					}
				});
			}
			
			@Override
			public TemplateManager createDefaultTemplateManager()
			{
				return new JsoupTemplateManager(TEMPLATE_ROOT, TemplateManagerTools.loadRecursiveWithDevelopementReload(TEMPLATE_ROOT, JsoupTemplateManager.PARSER, "html"));
			}
			
			@Override
			public void applyView(Context ctx) throws Exception
			{
				Element dom = JsoupTools.getDom();//((Element) ((Map<String, Object>)ctx.getEnv().get("VIEW")).get("DOM"));
				OutputStream os = ctx.getResponse().getOutputStream();
				os.write(dom.html().getBytes());
				os.flush();
			}
		});
	}
	
}
