package eu.javaexperience.web.template.jsoup;

import java.io.File;
import java.util.Map;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.fs.os.OsFile;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.prog.Debug;
import eu.javaexperience.web.template.AbstractTemplateManager;
import eu.javaexperience.web.template.TemplateManager;
import eu.javaexperience.web.template.TemplateManagerTools;

public class JsoupTemplateManager extends AbstractTemplateManager<JsoupTemplate>
{
	public JsoupTemplateManager(AbstractFile root, Map<String, JsoupTemplate> views)
	{
		super(root, "html", views);
	}

	public static final GetBy1<JsoupTemplate, String> PARSER = new GetBy1<JsoupTemplate, String>()
	{
		@Override
		public JsoupTemplate getBy(String a)
		{
			Debug.placeholderForBreakpoint();
			boolean body = a.contains("html");
			Element e = null;
			if(body)
			{
				e = Jsoup.parse(a);
			}
			else
			{
				Elements es = Jsoup.parseBodyFragment(a).body().children();
				if(es.size() == 1)
				{
					e = es.get(0);
				}
				else
				{
					e = new Element("div");
					for(Element add:es)
					{
						e.prependChild(add);
					}
				}
			}
			
			return new JsoupTemplate(e);
		}
	};

	@Override
	public JsoupTemplate getView(String label)
	{
		JsoupTemplate t = super.getView(label);
		if(null == t)
		{
			return null;
		}
		return new JsoupTemplate(t.getElement().clone());
	}

	public static TemplateManager parseFromDir(File dir)
	{
		return new JsoupTemplateManager(new OsFile(dir), TemplateManagerTools.loadRecursiveWithDevelopementReload(dir, PARSER, "html"));
	}
}
