/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.dom.jsoup;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.dom.build.CPathBuilder;
import eu.javaexperience.web.dom.build.CPathExpression;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class JsoupEditTools {
    public static final CPathBuilder<Element> CPATH_BUILDER = new CPathBuilder<Element>(){

        public Element createTag(String name) {
            return new Element(name);
        }

        public void addChild(Element elem, Element t) {
            elem.appendChild((Node)t);
        }

        public void setId(Element ref, String group) {
            ref.attr("id", group);
        }

        public void setText(Element ref, String group) {
            ref.text(group);
        }

        public void addClass(Element ref, String group) {
            ref.addClass(group);
        }

        public void addAttribute(Element ref, String k, @MayNull String v) {
            if (null == v) {
                ref.attr(k, true);
            } else {
                ref.attr(k, v);
            }
        }
    };

    public static void doOn(Element doc, String selector, SimplePublish1<Element> actor) {
        for (Element e : doc.select(selector)) {
            actor.publish((Object)e);
        }
    }

    public static SimplePublish1<Element> setAttr(final String attr, final String value) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                if (null == value) {
                    a.attr(attr, false);
                } else if (0 == value.length()) {
                    a.attr(attr, true);
                } else {
                    a.attr(attr, value);
                }
            }
        };
    }

    public static SimplePublish1<Element> setInnerText(final String value) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                a.text(value);
            }
        };
    }

    public static SimplePublish1<Element> setInnerHTML(final String value) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                a.html(value);
            }
        };
    }

    public static SimplePublish1<Element> setOuterHTML(final String value) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                a.wrap(value);
            }
        };
    }

    public static SimplePublish1<Element> insertAdjacentHTML(final AdjacentPosition poz, final String html) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                switch (poz) {
                    case AfterBegin: {
                        a.before(html);
                        break;
                    }
                    case AfterEnd: {
                        a.prepend(html);
                        break;
                    }
                    case BeforeBegin: {
                        a.append(html);
                        break;
                    }
                    case BeforeEnd: {
                        a.after(html);
                        break;
                    }
                }
            }
        };
    }

    public static Element createDomByExpression(String expression) {
        return (Element)CPathExpression.parse(CPATH_BUILDER, (String)expression);
    }

    public static String createDomStringByExpression(String expression) {
        return JsoupEditTools.createDomByExpression(expression).toString();
    }

    public static SimplePublish1<Element> addText(final String text) {
        return new SimplePublish1<Element>(){

            public void publish(Element a) {
                a.appendText(text);
            }
        };
    }

    public static enum AdjacentPosition {
        BeforeBegin,
        AfterBegin,
        BeforeEnd,
        AfterEnd;

    }
}

