/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.jsoup;

import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.dom.jsoup.JsoupEditTools;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.web.CdnFramework;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.TemplateWebsiteContext;
import eu.javaexperience.web.TemplateWebsiteTools;
import eu.javaexperience.web.dom.build.CPathExpression;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.template.FileBasedTemplateManager;
import eu.javaexperience.web.template.TemplateManager;
import eu.javaexperience.web.template.jsoup.JsoupTemplate;
import java.util.Collection;
import java.util.Map;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class JsoupTools {
    @Ignore
    public static void addTemplateWebsiteDefaultDomGetter(String templateManagerView) {
        JsoupTools.addTemplateWebsiteDefaultDomGetter(templateManagerView, null);
    }

    public static void addTemplateWebsiteDefaultDomGetter(final String templateManagerView, SimplePublish1<Element> initTemplate) {
        final Context ctx = SiteFacilityTools.getCurrentContext();
        Map VIEW = (Map)ctx.getEnv().get("VIEW");
        VIEW.put("DOM_GETTER", new GetBy1<JsoupTemplate, Context>(){

            public JsoupTemplate getBy(Context a) {
                return (JsoupTemplate)TemplateWebsiteTools.getTemplate((Context)ctx, (String)templateManagerView);
            }
        });
        VIEW.put("DOM_INIT", initTemplate);
    }

    public static Element getDom() {
        Context ctx = SiteFacilityTools.getCurrentContext();
        Map VIEW = (Map)ctx.getEnv().get("VIEW");
        Object tmpl = VIEW.get("root");
        if (tmpl instanceof JsoupTemplate) {
            return ((JsoupTemplate)((Object)tmpl)).getElement();
        }
        Object getter = VIEW.get("DOM_GETTER");
        if (!(getter instanceof GetBy1)) {
            throw new RuntimeException("Dom getter not preset in context: env.VIEW.DOM_GETTER should be an(GetBy1<JsoupTemplate, Context>)");
        }
        JsoupTemplate t = (JsoupTemplate)((Object)((GetBy1)getter).getBy((Object)ctx));
        VIEW.put("root", t);
        Object init = VIEW.get("DOM_INIT");
        if (null != init) {
            if (!(init instanceof SimplePublish1)) {
                throw new RuntimeException("If Dom initialiser reset in : env.VIEW.DOM_INIT it's should be an(SimplePublish<Element>)");
            }
            ((SimplePublish1)init).publish((Object)t.getElement());
        }
        return t.getElement();
    }

    public static void addViewInto(String selector, String view) {
        Context ctx = SiteFacilityTools.getCurrentContext();
        Element e = JsoupTools.getDom();
        Element t = e.select(selector).first();
        JsoupTemplate templ = (JsoupTemplate)TemplateWebsiteTools.getTemplate((Context)ctx, (String)view);
        if (null != templ) {
            t.appendChild((Node)templ.getElement());
        }
    }

    public static void addExpressionInto(String selector, String ... expressions) {
        Element e = JsoupTools.getDom();
        Element t = e.select(selector).first();
        if (null != t) {
            for (String expression : expressions) {
                if (null == expression) continue;
                t.appendChild((Node)CPathExpression.parse(JsoupEditTools.CPATH_BUILDER, (String)expression));
            }
        }
    }

    public static void appendElementInto(String selector, Element ... els) {
        Element e = JsoupTools.getDom();
        Element t = e.select(selector).first();
        for (Element el : els) {
            if (null == el) continue;
            t.appendChild((Node)el);
        }
    }

    public static Element createJsLink(String link) {
        Element e = new Element("script");
        e.attr("type", "text/javascript");
        e.attr("src", link);
        return e;
    }

    public static Element createCssLink(String link) {
        Element e = new Element("link");
        e.attr("type", "text/css");
        e.attr("rel", "stylesheet");
        e.attr("href", link);
        return e;
    }

    public static void linkPreJs(String ... links) {
        Element e = JsoupTools.getDom();
        Element t = e.select("head").first();
        if (null != t) {
            for (String s : links) {
                if (null == s) continue;
                t.appendChild((Node)JsoupTools.createJsLink(s));
            }
        }
    }

    public static void linkCss(String ... links) {
        Element e = JsoupTools.getDom();
        Element t = e.select("head").first();
        if (null != t) {
            for (String s : links) {
                if (null == s) continue;
                t.appendChild((Node)JsoupTools.createCssLink(s));
            }
        }
    }

    public static void linkPostJs(String ... links) {
        Element e = JsoupTools.getDom();
        Element t = e.select("html").first();
        if (null != t) {
            for (String s : links) {
                if (null == s) continue;
                t.appendChild((Node)JsoupTools.createJsLink(s));
            }
        }
    }

    protected static Element wrapTemplate(String name, String content) {
        Element add = new Element("script");
        add.attr("type", "x-tmpl-mustache");
        add.attr("data-template", name);
        add.appendChild((Node)new DataNode(content, ""));
        return add;
    }

    public static void exportTemplatePackage(String intoCssSelector, String _package) {
        Context ctx = SiteFacilityTools.getCurrentContext();
        TemplateWebsiteContext fw = TemplateWebsiteTools.getContextTemplateFw((Context)ctx);
        TemplateManager tm = fw.getWebContext().getTemplateaManger();
        if (tm instanceof FileBasedTemplateManager) {
            FileBasedTemplateManager fbtm = (FileBasedTemplateManager)tm;
            Element e = JsoupTools.getDom();
            final Element t = e.select(intoCssSelector).first();
            if (null != t) {
                TemplateWebsiteTools.exportTemplatePackage((Collection)new PublisherCollection<TemplateWebsiteTools.ExportTemplate>(){

                    public boolean add(TemplateWebsiteTools.ExportTemplate obj) {
                        String content = null;
                        try {
                            content = obj.getContent();
                        }
                        catch (Throwable e) {
                            content = obj.formatException(e);
                        }
                        t.appendChild((Node)JsoupTools.wrapTemplate(obj.getName(), content));
                        return true;
                    }
                }, (String)fbtm.getRootDir().toString(), (String)_package, (String)fbtm.getExtension());
            }
        }
    }

    public static void addInlineTemplate(String intoCssSelector, String name, String expression) {
        Element e = JsoupTools.getDom();
        Element t = e.select(intoCssSelector).first();
        if (null != t) {
            t.appendChild((Node)JsoupTools.wrapTemplate(name, ((Element)CPathExpression.parse(JsoupEditTools.CPATH_BUILDER, (String)expression)).toString()));
        }
    }

    public static void addClientFramework(CdnFramework ... fw) {
        for (CdnFramework f : fw) {
            if (null == f) continue;
            if (null != f.preJs) {
                for (String s : f.preJs) {
                    JsoupTools.linkPreJs(s);
                }
            }
            if (null != f.css) {
                for (String s : f.css) {
                    JsoupTools.linkCss(s);
                }
            }
            if (null == f.postJs) continue;
            for (String s : f.postJs) {
                JsoupTools.linkPostJs(s);
            }
        }
    }

    public static void addScriptAfter(String content, String selector) {
        Element e = new Element("script");
        e.attr("type", "text/javascript");
        e.text(content);
        JsoupTools.getDom().select(selector).first().appendChild((Node)e);
    }

    public static void addScriptTrigger(String partname) {
        JsoupTools.addRawIdDomTrigger("js_trigger_" + partname);
    }

    public static void addRawIdDomTrigger(String id) {
        Element dom = JsoupTools.getDom();
        Element e = dom.select("body").first();
        if (null != e) {
            Element add = new Element("div");
            add.addClass("js_trigger_unit");
            add.attr("id", id);
            e.appendChild((Node)add);
        }
    }

    public static void setInnerText(String selector, String text) {
        JsoupEditTools.doOn(JsoupTools.getDom(), selector, JsoupEditTools.setInnerText(text));
    }

    public static void addText(String selector, String text) {
        JsoupEditTools.doOn(JsoupTools.getDom(), selector, JsoupEditTools.addText(text));
    }

    public static void attr(String selector, String key, String val) {
        JsoupEditTools.doOn(JsoupTools.getDom(), selector, JsoupEditTools.setAttr(key, val));
    }

    public static void main(String[] args) {
        System.out.println(CdnFramework.exportToJs());
    }
}

