/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.template.jsoup;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.fs.os.OsFile;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.prog.Debug;
import eu.javaexperience.web.template.AbstractTemplateManager;
import eu.javaexperience.web.template.TemplateManager;
import eu.javaexperience.web.template.TemplateManagerTools;
import eu.javaexperience.web.template.jsoup.JsoupTemplate;
import java.io.File;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class JsoupTemplateManager
extends AbstractTemplateManager<JsoupTemplate> {
    public static final GetBy1<JsoupTemplate, String> PARSER = new GetBy1<JsoupTemplate, String>(){

        public JsoupTemplate getBy(String a) {
            Debug.placeholderForBreakpoint();
            boolean body = a.contains("html");
            Document e = null;
            if (body) {
                e = Jsoup.parse((String)a);
            } else {
                Elements es = Jsoup.parseBodyFragment((String)a).body().children();
                if (es.size() == 1) {
                    e = (Element)es.get(0);
                } else {
                    e = new Element("div");
                    for (Element add : es) {
                        e.prependChild((Node)add);
                    }
                }
            }
            return new JsoupTemplate((Element)e);
        }
    };

    public JsoupTemplateManager(AbstractFile root, Map<String, JsoupTemplate> views) {
        super(root, "html", views);
    }

    public JsoupTemplate getView(String label) {
        JsoupTemplate t = (JsoupTemplate)super.getView(label);
        if (null == t) {
            return null;
        }
        return new JsoupTemplate(t.getElement().clone());
    }

    public static TemplateManager parseFromDir(File dir) {
        return new JsoupTemplateManager((AbstractFile)new OsFile(dir), TemplateManagerTools.loadRecursiveWithDevelopementReload((File)dir, PARSER, (String)"html"));
    }
}

