package eu.javaexperience.web.server.commons;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.server.http.HttpRequest;
import eu.javaexperience.web.server.http.HttpRequestProperty;
import eu.javaexperience.web.server.http.HttpSocketProtocol;
import eu.javaexperience.web.server.http.HttpSocketProtocolHandler;

public abstract class AbstractHttpProtocolHandler implements HttpSocketProtocolHandler
{
	protected final IOStream ioStream;
	protected final HttpSocketProtocol protocol;
	
	public AbstractHttpProtocolHandler(IOStream stream, HttpSocketProtocol protocol)
	{
		this.ioStream = stream;
		this.protocol = protocol;
	}
	
	protected IOStream wrappedSocket;
	
	@Override
	public void initRequest() throws IOException
	{
		wrappedSocket = initSocketRequest();
	}
	
	protected abstract IOStream initSocketRequest() throws IOException;
	
	@Override
	public IOStream getWrappedStream()
	{
		return wrappedSocket;
	}
	
	@Override
	public IOStream getRawStream()
	{
		return ioStream;
	}
	
	@Override
	public HttpSocketProtocol getProtocolInfo()
	{
		return protocol;
	}
	
	protected EnumMap<HttpRequestProperty, String> requestProperties = new EnumMap<>(HttpRequestProperty.class);
	protected Map<String, String> requestHeaders;
	protected Map<String, String[]> reqParams;
	
	protected void setParsedRequestProperties
	(
		String reqProtocol,
		String reqMethod,
		String reqDomain,
		String reqPort,
		String reqURI,
		String reqURL,
		String reqQuery,
		Map<String, String> reqHeaders,
		Map<String, String[]> reqQueryParams
	)
	{
		requestProperties.put(HttpRequestProperty.PROTOCOL, reqProtocol);
		requestProperties.put(HttpRequestProperty.METHOD, reqMethod);
		requestProperties.put(HttpRequestProperty.PORT, reqPort);
		requestProperties.put(HttpRequestProperty.DOMAIN, reqDomain);
		requestProperties.put(HttpRequestProperty.URI, reqURI);
		requestProperties.put(HttpRequestProperty.URL, reqURL);
		requestProperties.put(HttpRequestProperty.QUERY, reqQuery);
		this.requestHeaders = reqHeaders;
		this.reqParams = reqQueryParams;
		
	}
	
	@Override
	public String getHttpRequestProperty(HttpRequestProperty prop)
	{
		return requestProperties.get(prop);
	}
	
	@Override
	public Map<String, String> getRequestHeaders()
	{
		return requestHeaders;
	}
	
	@Override
	public Map<String, String[]> getQueryParams()
	{
		return reqParams;
	}
	
	
	private String getUploadTmpDir()
	{
		return "/tmp/";
	}
	
	public static void handlePosts(HttpServletRequest request, Map<String, String[]> reqParams, String uploadDir) throws IOException 
	{
		/*if(!"POST".equalsIgnoreCase(method))
		return;*/
	
	
	//String contentType = request.getContentType();
	
	InputStream is = request.getInputStream();
	
	if(ServletFileUpload.isMultipartContent(request))
	{
		ServletFileUpload upload = new ServletFileUpload();
	
		Map<String, UploadedFile> files = new MultiMap<>();
		
		try
		{
			FileItemIterator it = upload.getItemIterator(request);
			while(it.hasNext())
			{
				FileItemStream fis = it.next();
				String name = fis.getFieldName();
				InputStream stream = fis.openStream();
	
				if(fis.isFormField())
					UrlTools.putParam(reqParams ,name, Streams.asString(stream));
				else
				{
					File file = FileTools.generateTempFilename(uploadDir,30,".tmp");
					FileOutputStream fos = new FileOutputStream(file);
					IOTools.copyStream(stream, fos);
					fos.flush();
					fos.close();
					UploadedFile fi = new UploadedFile(file, fis.getName());
					files.put(name,fi);
				}
			}
		}
		catch(Exception e)
		{
			throw new RuntimeException(e);
		}
		
		request.setAttribute("files", files);
		return;
	}
	
	{
		int n = request.getContentLength();
		int ava = is.available();
		if(n <= 0 && ava > 0)
			n = is.available();
		
		//TODO
		//if(n > 20480)
		//	throw new RuntimeException("POST size too big");
		
		byte[] data = null;
		if(n > 0)
		{
			data = new byte[n];
			//String line = LineReader.readLine(is, LineMode.Mac);
			//System.out.println(line);
			IOTools.readFull(is, data);
		}
		else
		{
			data = IOTools.loadAllAvailableFromInputStream(is);
		}
		try
		{
			UrlTools.processArgsRequest(new String(data), reqParams);
		}
		catch(Exception e){}
		request.setAttribute("data", data);
	}
	}
	
	@Override
	public void handlePosts(HttpRequest request) throws IOException
	{
		handlePosts(request, reqParams, getUploadTmpDir());
	}
	
	public static void appendHttpStatus(Appendable sb, int status, String msg, String lineEnd) throws IOException
	{
		sb.append("HTTP/1.1 ");
		sb.append(String.valueOf(status));
		sb.append(" ");
		sb.append(msg);
		sb.append(lineEnd);
	}
	
	public static void appendHeaders(Appendable sb, Map<String, String> send, String lineEnd) throws IOException
	{
		for(Entry<String,String> kv:send.entrySet())
		{
			sb.append(kv.getKey());
			sb.append(": ");
			sb.append(kv.getValue());
			sb.append(lineEnd);
		}
	}
}
