package eu.javaexperience.web.server.http;

import eu.javaexperience.io.IOStream;
import eu.javaexperience.web.server.lightning.protocol.FcgiProtocolHandler;
import eu.javaexperience.web.server.lightning.protocol.PlainHttpProtocolHandler;

public enum WellKnownSocketHttpProtocol implements HttpSocketProtocol
{
	INTERNAL()
	{
		@Override
		public HttpSocketProtocolHandler createQuery(IOStream stream)
		{
			throw new RuntimeException("Internal HttpConnection only can be created by invoking new InternalHttpProtocol(...) (or you can use socketparis and RAW_HTTP protocol)");
		}
	},
	
	RAW_HTTP()
	{
		@Override
		public HttpSocketProtocolHandler createQuery(IOStream stream)
		{
			return new PlainHttpProtocolHandler(stream);
		}
	},
	FASTCGI()
	{
		@Override
		public HttpSocketProtocolHandler createQuery(IOStream stream)
		{
			return new FcgiProtocolHandler(stream);
		}
	},
	
	//TODO https://httpd.apache.org/docs/2.4/mod/mod_proxy_ajp.html
	AJP13()
	{
		@Override
		public HttpSocketProtocolHandler createQuery(IOStream stream)
		{
			throw new RuntimeException("AJP1.3: TODO implement me");
		}
	},
	
	;

	@Override
	public String getName()
	{
		return name();
	}
}
