package eu.javaexperience.web.server.lightningImpl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

import eu.javaexperience.collection.enumerations.EnumerationFromIterator;
import eu.javaexperience.collection.enumerations.OneShotEnumeration;
import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.AutoFlushListener;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Headers;
import eu.javaexperience.web.HttpResponseStatusCode;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.features.WebSocketEndpoint;
import eu.javaexperience.web.server.commons.LightningConnectionClosed;
import eu.javaexperience.web.server.commons.LightningOutput;
import eu.javaexperience.web.server.commons.UploadedFile;
import eu.javaexperience.web.server.http.HttpQueryContext;
import eu.javaexperience.web.server.http.HttpRequest;
import eu.javaexperience.web.server.http.HttpRequestProperty;
import eu.javaexperience.web.server.http.HttpResponse;
import eu.javaexperience.web.server.http.HttpServingTimeMetric;
import eu.javaexperience.web.server.http.HttpSocketProtocolHandler;

public class LightningHttpQueryContext implements Closeable, AutoCloseable, Flushable, HttpQueryContext
{
	protected final IOStream socket;
	
	protected final Map<String, String> respHeader = defaultResponseHeaders();
	protected final List<Cookie> outCookies = new ArrayList<>();
	protected final List<Cookie> inCookies = new ArrayList<>();
	
	protected HttpResponseStatusCode statusResponse = HttpResponseStatusCode._200_OK;
	
	protected boolean isServiceEnded = false;
	
	public void assertHeaderNotSent()
	{
		if(isHeadersSent())
			throw new IllegalStateException("Header alredy sent");
	}
	
	public void fillHeaders(Map<String, String> forHeaders)
	{
		assertHeaderNotSent();
		//srv.getBeforeHeaderSent().interfere(this);
		
		forHeaders.putAll(respHeader);
		
		for(Cookie c:outCookies)
		{
			if(c.getComment() == HttpTools.commentCookieSet)
			{
				forHeaders.put("Set-Cookie", HttpTools.renderCookie(c, false));
			}
		}
	}
	
	public static Map<String,String> defaultResponseHeaders()
	{
		Map<String,String> ret = new SmallMap<>();
		ret.put("Content-Type", "text/html; charset=utf-8");
		ret.put("X-Powered-By","Lightning");
		return ret;
	}
	
	protected int bufferSize;
	
	@Override
	public IOStream getSocket()
	{
		return socket;
	}
	
	protected final HttpSocketProtocolHandler protocolHandler;
	protected final LightningOutput out;
	protected final InputStream is;
	
	
	//optputStreamek összefűzése egy bufferelt kimenetbe ami egy ideig tárolja a kiírt adatokat és ha az a kérelem kiszolgálás végére nem haladta meg a buffer 
	//méretet Content-Length-el kiküldi!
	// célszerű egy writert szinkronizálatlanná tenni... OutputStream => BufferedOutputStream => * ServletOutputStream => StreamEncoder => UnconcurrentWriter => PrintWriter
	public LightningHttpQueryContext(HttpSocketProtocolHandler protoHandler) throws LightningConnectionClosed
	{
		this.protocolHandler = protoHandler;
		this.socket = protoHandler.getWrappedStream();
		
		for(Entry<String, String> kv:protoHandler.getRequestHeaders().entrySet())
		{
			HttpTools.tryRecogniseCookieHeader(inCookies, kv.getKey(), kv.getValue());
		}
		
		is = socket.getInputStream();
		out = LightningOutput.create(socket.getOutputStream(), onAutoFlush);
		out.setOwner(this);
	}
	
	private boolean headerSent = false;
	
	protected boolean contentLengthSet = false;
	
	//protected BufferedReader br;
	
	protected boolean finalLengthSent = false;
	
	public boolean isLengthGivenAtHeaderSend()
	{
		//akkor ha a flush a seriveEnded után lett hívva
		return finalLengthSent;
	}
	
	@Override
	public WebSocketEndpoint upgradeWebsocket() throws IOException
	{
		throw new RuntimeException("TODO reimplement");
		
		
		//disable output header send
		//headerSent = true;
		
		/*
		String key = request.getHeader("Sec-WebSocket-Key");
		
		if(null == key)
		{
			key = request.getHeader("Sec-Websocket-Key");
		}
		
		return WebSocketEndpoint.upgradeConnection(this);*/
	}
	
	protected static void flushAnyWay(LightningHttpQueryContext lsrr) throws IOException
	{
		lsrr.out.flushBuffer();
		/*if(lsrr.pw instanceof LocklessBufferedOutputStreamUtf8PrintWriter)
		{
			((LocklessBufferedOutputStreamUtf8PrintWriter) lsrr.pw).flushBuffer();
		}
		else
		{
			lsrr.pw.flush();
			lsrr.out.flush();
		}*/
	}

	protected static final AutoFlushListener<LightningOutput> onAutoFlush =
		new AutoFlushListener<LightningOutput>()
	{
		@Override
		public void beforeUserFlush(LightningOutput f)
		{
		}

		@Override
		public void afterUserFlush(LightningOutput b)
		{
			LightningHttpQueryContext f = (LightningHttpQueryContext) b.getOwner();
			if(f.isOperationEnded())
			{
				try
				{
					b.flushBuffer();
				}
				catch (IOException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}

		@Override
		public void beforeBufferFlush(LightningOutput b)
		{
			try//meg kell tudni hogy véget ért-e a kiszolgálás, ha igen akkor még a Content-Length-et bele kell írni.
			{
				LightningHttpQueryContext f = (LightningHttpQueryContext) b.getOwner();
				//setting the content length is implemented in sendHeaders()
				
				if(!f.isHeadersSent())
				{
					f.sendHeaders();
				}
			}
			catch(Exception e)
			{
				Mirror.propagateAnyway(e);
			}
		}

		@Override
		public void afterBufferFlush(LightningOutput f)
		{}
	};
	
	public boolean isHeadersSent()
	{
		return headerSent;
	}

	public void sendHeaders() throws IOException
	{
		//if all required data filled into buffer and operation ended, we send also the content length
		if(isOperationEnded())
		{
			finalLengthSent = true;
			int len = getResponseContentLength();
			
			Map<String,String> send = new BulkTransitMap<>();
			fillHeaders(send);
			if(len > -1)
			{
				send.put(Headers.ContentLength.getHeaderName(), String.valueOf(len));
			}
			contentLengthSet = true;
			sendHeaders(send);
		}
		else
		//buffer is fullfilled or flush called and first we send the headers
		{
			Map<String,String> send = new BulkTransitMap<>();
			fillHeaders(send);
			sendHeaders(send);
		}
	}
	
	public void sendHeaders(Map<String, String> send) throws IOException
	{
		if(headerSent)
			throw new RuntimeException("Header already sent!");
		
		
		headerSent = true;

		protocolHandler.sendResponseHeaders(out, statusResponse.getStatus(), statusResponse.getDescription(), send);
	}
	
	@Override
	public void flush() throws IOException
	{
		if(!isHeadersSent())
		{
			sendHeaders();
		}
		
		out.flush();
		socket.flush();
	}

	private ServletOutputStream initSos()
	{
		return new ServletOutputStream()
		{
			@Override
			public void write(int paramInt) throws IOException
			{
				out.write(paramInt);
			}
			
			public void write(byte[] d) throws IOException
			{
				out.write(d, 0, d.length);
			}
			
			public void write(byte[] d,int a,int b) throws IOException
			{
				out.write(d,a,b);
			}
			
			public void flush() throws IOException
			{
				out.flush();
			}
			
			public void close() throws IOException
			{
				out.close();
			}

			public boolean isReady()
			{
				return true;
			}

			public void setWriteListener(javax.servlet.WriteListener writeListener)
			{
				// TODO Auto-generated method stub
			}
		};
	}
	
	protected ServletOutputStream sos = null;
	
	public ServletOutputStream getServletOutputStream() throws IOException
	{
		if(sos == null)
			sos = initSos();
		
		return sos;
	}

	public void operationEnded()
	{
		isServiceEnded = true;
	}

	public boolean isOperationEnded()
	{
		return isServiceEnded;
	}

	public int getResponseContentLength()
	{
		return contentLength;
	}

	public String getResponseHead()
	{
		return statusResponse.toHeaderLineWhitoutLF();
	}

	public void putExtraAttribute(String string, Object data)
	{
		request.setAttribute(string, data);
	}
	
	protected ServletInputStream sin = null;
	
	protected ServletInputStream initSin()
	{
		return new ServletInputStream()
		{
			@Override
			public int read() throws IOException
			{
				return is.read();
			}
			
			public int read(byte[] d,int a,int b) throws IOException
			{
				return is.read(d, a, b);
			}
			
			public int read(byte[] d) throws IOException
			{
				return is.read(d);
			}

			public boolean isFinished() {
				// TODO Auto-generated method stub
				return false;
			}

			public boolean isReady() {
				// TODO Auto-generated method stub
				return false;
			}

			public void setReadListener(javax.servlet.ReadListener readListener) {
				// TODO Auto-generated method stub
				
			}
		};
	}
	
	//public static boolean useOutputBuffer = false;
	
	protected HttpSession session;
	
	public void setSession(HttpSession session)
	{
		this.session = session;
	}

	private Map<String, Object> attr = null;
	
	private int contentLength = -1;

	public final HttpRequest request = new HttpRequest()
	{
		public Object getAttribute(String name)
		{
			if("lightning".equals(name))
			{
				return LightningHttpQueryContext.this;
			}
			else if(attr == null)
			{
				return null;
			}
			return attr.get(name);
		}

		@Override
		public Enumeration<String> getAttributeNames()
		{
			if(attr == null)
				return new OneShotEnumeration("lightning");
			return new EnumerationFromIterator<>(attr.keySet());
		}

		@Override
		public String getCharacterEncoding()
		{
			return getHeader("accept-charset");
		}

		@Override
		public int getContentLength()
		{
			String hcl = getHeader("http_content_length");
			String cl = getHeader("Content-Length");

			if(hcl != null)
				return Integer.parseInt(hcl);
			else if(cl != null)
				return Integer.parseInt(cl);

			return -1;
		}

		@Override
		public String getContentType()
		{
			return getHeader("Content-Type");
		}

		@Override
		public String getParameter(String name)
		{
			String[] re = protocolHandler.getQueryParams().get(name);
			if(re == null || re.length == 0)
				return null;
			
			return re[0];
		}

		@Override
		public Enumeration<String> getParameterNames()
		{
			return new EnumerationFromIterator<>(protocolHandler.getQueryParams().keySet());
		}

		@Override
		public String[] getParameterValues(String name)
		{
			return protocolHandler.getQueryParams().keySet().toArray(Mirror.emptyStringArray);
		}

		@Override
		public Map<String,String[]> getParameterMap()
		{
			return protocolHandler.getQueryParams();
		}

		@Override
		public void setAttribute(String name, Object o)
		{
			if(attr == null)
				attr = new SmallMap<>();
		
			attr.put(name, o);
		}

		@Override
		public void removeAttribute(String name)
		{
			if(attr != null)
				attr.remove(name);
		}
		
		@Override
		public ServletInputStream getInputStream() throws IOException
		{
			if(sin == null)
				sin = initSin();
			return sin;
		}
		
		public String getRequestProtocol()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.PROTOCOL);
		}

		public int getRequestPort()
		{
			return Integer.parseInt(protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT));
		}


		public String getRequestDomain()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN);
		}


		public String getRequestPath()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.URI);
		}

		public StringBuffer getRequestURL()
		{
			StringBuffer ret = new StringBuffer();
			ret.append("http://");
			ret.append(protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN));
			String port = protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT);
			if(null != port)
			{
				Integer p = ParsePrimitive.tryParseInt(port);
				if(null != p && 80 != (int)p)
				{
					ret.append(":");
					ret.append(port);
				}
			}
			ret.append(protocolHandler.getHttpRequestProperty(HttpRequestProperty.URI));
			return ret;
		}

		@Override
		public AsyncContext startAsync(ServletRequest paramServletRequest,
				ServletResponse paramServletResponse) throws IllegalStateException {
			return null;
		}
		
		@Override
		public AsyncContext startAsync() throws IllegalStateException
		{
			return null;
		}
		
		
		
		
		@Override
		public void setCharacterEncoding(String paramString)
				throws UnsupportedEncodingException {
			
		}
		
		@Override
		public boolean isAsyncSupported() {
			return false;
		}
		
		@Override
		public boolean isAsyncStarted() {
			return false;
		}
		
		@Override
		public ServletContext getServletContext() {
			return null;
		}
		
		@Override
		public RequestDispatcher getRequestDispatcher(String paramString) {
			return null;
		}
		
		@Override
		public String getRealPath(String paramString) {
			return null;
		}
		
		@Override
		public Enumeration<Locale> getLocales() {
			return null;
		}
		
		@Override
		public Locale getLocale() {
			return null;
		}
		
		@Override
		public DispatcherType getDispatcherType() {
			return null;
		}
		
		@Override
		public AsyncContext getAsyncContext() {
			return null;
		}
		
		@Override
		public void logout() throws ServletException {
			
		}
		
		@Override
		public void login(String paramString1, String paramString2)
				throws ServletException {
		}
		
		@Override
		public boolean isUserInRole(String paramString) {
			return false;
		}
		
		@Override
		public boolean isRequestedSessionIdValid() {
			return false;
		}
		
		@Override
		public boolean isRequestedSessionIdFromUrl() {
			return false;
		}
		
		@Override
		public boolean isRequestedSessionIdFromURL() {
			return false;
		}
		
		@Override
		public boolean isRequestedSessionIdFromCookie() {
			return false;
		}
		
		@Override
		public Principal getUserPrincipal() {
			return null;
		}
		
		@Override
		public HttpSession getSession(boolean paramBoolean)
		{
			return session;
		}
		
		@Override
		public HttpSession getSession()
		{
			return session;
		}
		
		@Override
		public String getServletPath() {
			return null;
		}
		
		@Override
		public String getRequestedSessionId() {
			return null;
		}
		
		@Override
		public String getRequestURI()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.URL);//ahhoz képest ami a doksiba szerepel... tomcat is ezt csinálja...
		}
		
		@Override
		public String getRemoteUser() {
			return null;
		}
		
		@Override
		public String getQueryString()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.QUERY);
		}
		
		@Override
		public String getPathTranslated() {
			return null;
		}
		
		@Override
		public String getPathInfo() {
			return null;
		}
		
		@Override
		public Collection<Part> getParts() throws IOException, ServletException {
			return null;
		}
		
		@Override
		public Part getPart(String paramString) throws IOException,
				ServletException {
			return null;
		}
		
		@Override
		public String getMethod()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.METHOD);
		}
		
		@Override
		public int getIntHeader(String paramString) {
			// TODO Auto-generated method stub
			return 0;
		}
		
		@Override
		public Enumeration<String> getHeaders(String paramString) {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public Enumeration<String> getHeaderNames()
		{
			return new EnumerationFromIterator(protocolHandler.getRequestHeaders().keySet());
		}
		
		@Override
		public String getHeader(String paramString)
		{
			return protocolHandler.getRequestHeaders().get(paramString);
		}
		
		@Override
		public long getDateHeader(String paramString) {
			// TODO Auto-generated method stub
			return 0;
		}
		
		@Override
		public Cookie[] getCookies()
		{
			return inCookies.toArray(HttpTools.emptyCookieArray);
		}
		
		@Override
		public String getContextPath() {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public String getAuthType() {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public boolean authenticate(HttpServletResponse paramHttpServletResponse)
				throws IOException, ServletException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getProtocol()
		{
			return "http";
		}

		@Override
		public String getScheme()
		{
			return "http";
		}

		@Override
		public String getServerName()
		{
			return protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN);
		}

		@Override
		public int getServerPort()
		{
			return Integer.parseInt(protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT));
		}

		@Override
		public BufferedReader getReader() throws IOException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getRemoteAddr()
		{
			return socket.remoteAddress();
		}

		@Override
		public String getRemoteHost() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public boolean isSecure() {
			return false;
		}

		@Override
		public int getRemotePort() {
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public String getLocalName() {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getLocalAddr()
		{
			return socket.localAddress();
		}

		@Override
		public int getLocalPort()
		{
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public HttpQueryContext getQuery()
		{
			return LightningHttpQueryContext.this;
		}

		public String changeSessionId() {
			return null;
		}

		public <T extends javax.servlet.http.HttpUpgradeHandler> T upgrade(Class<T> handlerClass)
				throws IOException, ServletException {
			// TODO Auto-generated method stub
			return null;
		}

		public long getContentLengthLong() {
			// TODO Auto-generated method stub
			return 0;
		}
	}; 
	
	
	public final HttpResponse response = new HttpResponse()
	{
		@Override
		public void setContentLength(int len)
		{
			respHeader.put(Headers.ContentLength.getHeaderName(), String.valueOf(len));
			contentLength = len;
		}

		@Override
		public void setContentType(String type)
		{
			respHeader.put(Headers.ContentType.getHeaderName(), type);
		}
		
		
		@Override
		public void setBufferSize(int size)
		{
			throw new IllegalAccessError("Buffer size is specified in ServletConfig");
		}

		@Override
		public int getBufferSize()
		{
			return bufferSize;
		}

		@Override
		public void flushBuffer() throws IOException
		{
			flush();
		}
		
		@Override
		public void addCookie(Cookie cookie)
		{
			cookie.setComment(HttpTools.commentCookieSet);
			outCookies.add(cookie); //több ugyanolyannál...
		}

		@Override
		public boolean containsHeader(String name)
		{
			return respHeader.containsKey(name);
		}

		@Override
		public String encodeURL(String url)
		{
			return URLEncoder.encode(url);//ezmiez
		}

		@Override
		public String encodeRedirectURL(String url)
		{
			return URLEncoder.encode(url);//ezmiez
		}

		@Override
		public String encodeUrl(String url)
		{
			return URLEncoder.encode(url);//ezmiez
		}

		@Override
		public String encodeRedirectUrl(String url)
		{
			return URLEncoder.encode(url);//ezmiez
		}

		@Override
		public void setDateHeader(String name, long date)
		{
			respHeader.put(name, HttpTools.toHeaderDate(date));
		}

		@Override
		public void addDateHeader(String name, long date)
		{
			if(date < 0)
				return;
			String app = respHeader.get(name);
			if(app != null)
				app += ","+HttpTools.toHeaderDate(date);
			else
				app = HttpTools.toHeaderDate(date);
			respHeader.put(name, app);
		}

		@Override
		public void setHeader(String name, String value)
		{
			respHeader.put(name, value);
		}

		@Override
		public void addHeader(String name, String value)
		{
			String app = respHeader.get(name);
			if(app != null)
				app += ","+value;
			else
				app = value;
			respHeader.put(name, app);		
		}

		@Override
		public void setIntHeader(String name, int value)
		{
			respHeader.put(name, String.valueOf(value));		
		}

		@Override
		public void addIntHeader(String name, int value)
		{
			String app = respHeader.get(name);
			if(app != null)
				app += ","+String.valueOf(value);
			else
				app = String.valueOf(value);
			respHeader.put(name, app);
		}

		@Override
		public void setStatus(int sc)
		{
			statusResponse = HttpTools.httpResponseByNumber(sc);
		}

		@Override
		public void setStatus(int sc, String sm)
		{
			statusResponse = HttpTools.httpResponseByNumber(sc);
		}
		
		
		@Override
		public void setLocale(Locale paramLocale) {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public void setCharacterEncoding(String paramString) {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public void resetBuffer() {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public void reset() {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public boolean isCommitted()
		{
			return isHeadersSent();
		}
		
		@Override
		public Locale getLocale() {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public String getContentType() {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public String getCharacterEncoding() {
			// TODO Auto-generated method stub
			return null;
		}
		
		//TODO implement me
		
		@Override
		public void sendRedirect(String paramString) throws IOException
		{
			HttpTools.httpRedirect(this, paramString, false);
		}
		
		@Override
		public void sendError(int paramInt, String paramString) throws IOException
		{
			setStatus(paramInt, paramString);
			sendHeaders();
		}
		
		@Override
		public void sendError(int paramInt) throws IOException
		{
			setStatus(paramInt);
			sendHeaders();
		}
		
		@Override
		public int getStatus()
		{
			return statusResponse.getStatus();
		}
		
		@Override
		public Collection<String> getHeaders(String paramString)
		{
			return null;
		}
		
		@Override
		public Collection<String> getHeaderNames() {
			// TODO Auto-generated method stub
			return null;
		}
		
		@Override
		public String getHeader(String paramString) {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public ServletOutputStream getOutputStream() throws IOException
		{
			return getServletOutputStream();
		}

		@Override
		public PrintWriter getWriter() throws IOException
		{
			return out;
		}
		
		@Override
		public HttpQueryContext getQuery()
		{
			return LightningHttpQueryContext.this;
		}

		public void setContentLengthLong(long len)
		{
			setContentLength((int) len);
		}
	};

	public void setContentType(MIME type)
	{
		respHeader.put(Headers.ContentType.getHeaderName(), type.mime);
	}
	
	public void destroy()
	{
		if(attr != null)
		{
			Map<String, UploadedFile> files = MapTools.getIfType(attr, "files", Map.class);
			if(files != null)
			{
				for(Entry<String, UploadedFile> kv:files.entrySet())
				try
				{
					kv.getValue().getFile().delete();
				}
				catch(Throwable e){}
			}
		}
		attr = null;
	}
	
	@Override
	public void close() throws IOException
	{
		destroy();
		socket.close();
	}

	@Override
	public HttpSocketProtocolHandler getProtocol()
	{
		return protocolHandler;
	}

	@Override
	public HttpRequest getRequest()
	{
		return request;
	}

	@Override
	public HttpResponse getResponse()
	{
		return response;
	}

	protected final EnumMap<HttpServingTimeMetric, Long> times = new EnumMap<>(HttpServingTimeMetric.class);
	
	@Override
	public long getTimeMetric(HttpServingTimeMetric metic)
	{
		Long ret = times.get(metic);
		if(null == ret)
		{
			return 0;
		}
		return ret;
	}

	@Override
	public void setTimeMetric(HttpServingTimeMetric metic, long t)
	{
		times.put(metic, t);
	}

	@Override
	public HttpSession getSession()
	{
		return session;
	}

	public LightningOutput getLightningOutput()
	{
		return out;
	}
	
	protected void addProp(StringBuilder sb, String label, HttpRequestProperty prop)
	{
		sb.append(label);
		sb.append(": ");
		sb.append(protocolHandler.getHttpRequestProperty(prop));
		sb.append("\n");
	}
	
	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append(super.toString());
		sb.append(":{\n");
		
		addProp(sb, "request_url", HttpRequestProperty.URL);
		addProp(sb, "query", HttpRequestProperty.QUERY);
		sb.append("req_params: ");
		sb.append(MapTools.toStringMultiline(protocolHandler.getQueryParams()));
		
		
		return sb.toString();
	}
}
