/*
 * Decompiled with CFR 0.152.
 */
package com.fastcgi;

import com.fastcgi.FCGIInputStream;
import com.fastcgi.FCGIMessage;
import com.fastcgi.FCGIOutputStream;
import eu.javaexperience.io.IOStream;
import java.io.IOException;
import java.util.Properties;

public class FCGIRequest {
    private IOStream socket;
    private boolean isBeginProcessed;
    private int requestID;
    private boolean keepConnection;
    private int appStatus;
    private int numWriters;
    private FCGIInputStream inputStream;
    private FCGIOutputStream outputStream;
    private FCGIOutputStream errorStream;
    private Properties parameters;

    public int getId() {
        return this.getRequestID();
    }

    public IOStream getSocket() {
        return this.socket;
    }

    public void setSocket(IOStream socket) {
        this.socket = socket;
    }

    public boolean isBeginProcessed() {
        return this.isBeginProcessed;
    }

    public void setBeginProcessed(boolean beginProcessed) {
        this.isBeginProcessed = beginProcessed;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public boolean isKeepConnection() {
        return this.keepConnection;
    }

    public void setKeepConnection(boolean keepConnection) {
        this.keepConnection = keepConnection;
    }

    public int getAppStatus() {
        return this.appStatus;
    }

    public void setAppStatus(int appStatus) {
        this.appStatus = appStatus;
    }

    public int getNumWriters() {
        return this.numWriters;
    }

    public void setNumWriters(int numWriters) {
        this.numWriters = numWriters;
    }

    public FCGIInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(FCGIInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public FCGIOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(FCGIOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public FCGIOutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(FCGIOutputStream errorStream) {
        this.errorStream = errorStream;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    public static FCGIRequest readFromIOStream(IOStream stream) throws IOException {
        FCGIRequest request = new FCGIRequest();
        request.setSocket(stream);
        request.setBeginProcessed(false);
        request.setInputStream(new FCGIInputStream(request.getSocket().getInputStream(), 8192, 0, request));
        request.getInputStream().fill();
        if (!request.isBeginProcessed()) {
            request.getSocket().close();
            request.setSocket(null);
            return null;
        }
        request.setParameters(new Properties());
        request.getInputStream().setReaderType(4);
        FCGIMessage msg = new FCGIMessage(request.getInputStream());
        if (!msg.readParams(request.getParameters())) {
            return null;
        }
        request.getInputStream().setReaderType(5);
        request.setOutputStream(new FCGIOutputStream(request.getSocket().getOutputStream(), 8192, 6, request));
        request.setErrorStream(new FCGIOutputStream(request.getSocket().getOutputStream(), 512, 7, request));
        request.setNumWriters(2);
        return request;
    }
}

