/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.commons;

import eu.javaexperience.io.AutoFlushListener;
import eu.javaexperience.io.BufferedOutput;
import eu.javaexperience.reflect.Mirror;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class LightningOutput
extends PrintWriter {
    protected BufferedOutput buffOutput;
    protected final OutputStream backend;
    protected Object owner;
    protected OutputStream os = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            LightningOutput.this.buffOutput.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            LightningOutput.this.buffOutput.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LightningOutput.this.buffOutput.write(b, off, len);
        }

        @Override
        public void flush() {
            LightningOutput.this.flush();
        }
    };

    protected LightningOutput(OutputStream backend, BufferedOutput out) {
        super((OutputStream)out);
        this.backend = backend;
        this.buffOutput = out;
    }

    public static LightningOutput create(OutputStream out, final AutoFlushListener<LightningOutput> flush) {
        LightningOutput[] ptr;
        LightningOutput ret = new LightningOutput(out, new BufferedOutput(out){

            protected void flushBuffer() throws IOException {
                if (null != flush) {
                    flush.beforeBufferFlush((Flushable)ptr[0]);
                }
                super.flushBuffer();
                if (null != flush) {
                    flush.afterBufferFlush((Flushable)ptr[0]);
                }
            }
        });
        ptr = new LightningOutput[]{ret};
        return ret;
    }

    public OutputStream getBackendOutput() {
        return this.backend;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffOutput.write(b, off, len);
    }

    public OutputStream asOutputStream() {
        return this.os;
    }

    public void flushBuffer() throws IOException {
        this.buffOutput.flush();
    }

    @Override
    public void flush() {
        try {
            this.flushBuffer();
            super.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(char[] buf, int off, int len) {
        try {
            this.out.write(buf, off, len);
        }
        catch (Exception x) {
            Mirror.propagateAnyway((Throwable)x);
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }
}

