/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.lightning.protocol;

import com.fastcgi.FCGIOutputStream;
import com.fastcgi.FCGIRequest;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.server.commons.AbstractHttpProtocolHandler;
import eu.javaexperience.web.server.commons.LightningOutput;
import eu.javaexperience.web.server.http.WellKnownSocketHttpProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public class FcgiProtocolHandler
extends AbstractHttpProtocolHandler {
    protected FCGIRequest fcgi;

    public FcgiProtocolHandler(IOStream stream) {
        super(stream, WellKnownSocketHttpProtocol.FASTCGI);
    }

    @Override
    protected IOStream initSocketRequest() throws IOException {
        this.fcgi = FCGIRequest.readFromIOStream(this.ioStream);
        Properties p = this.fcgi.getParameters();
        String reqURL = p.getProperty("REQUEST_URI");
        SmallMap headers = new SmallMap();
        SmallMap query = new SmallMap();
        String reqQuery = p.getProperty("QUERY_STRING");
        if (null != reqQuery) {
            UrlTools.processArgsRequest((String)reqQuery, (Map)query);
        }
        for (Map.Entry<Object, Object> kv : p.entrySet()) {
            String k = kv.getKey().toString();
            if (!k.startsWith("HTTP_")) continue;
            k = HttpTools.headerFriendly((String)StringTools.getSubstringAfterFirstString((String)k, (String)"HTTP_"));
            String v = kv.getValue().toString();
            headers.put(k, v);
        }
        this.setParsedRequestProperties(p.getProperty("REQUEST_SCHEME"), p.getProperty("REQUEST_METHOD"), p.getProperty("SERVER_NAME"), p.getProperty("SERVER_PORT"), p.getProperty("REQUEST_URI"), reqURL, p.getProperty("QUERY_STRING"), (Map<String, String>)headers, (Map<String, String[]>)query);
        return IOStreamFactory.fromInAndOutputStream((InputStream)this.fcgi.getInputStream(), (OutputStream)this.fcgi.getOutputStream());
    }

    @Override
    public void sendResponseHeaders(LightningOutput os, int responseStatus, String responseStatusText, Map<String, String> send) throws IOException {
        String lineEnd = "\r\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Status: ");
        sb.append(String.valueOf(responseStatus));
        sb.append(lineEnd);
        FcgiProtocolHandler.appendHeaders(sb, send, lineEnd);
        sb.append(lineEnd);
        OutputStream out = os.getBackendOutput();
        out.write(sb.toString().getBytes());
        out.flush();
    }

    @Override
    public void finishTransmission(LightningOutput os) throws IOException {
        this.fcgi.setNumWriters(1);
        FCGIOutputStream out = this.fcgi.getOutputStream();
        out.empty(true);
    }
}

