/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.lightning.protocol;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.server.commons.AbstractHttpProtocolHandler;
import eu.javaexperience.web.server.commons.LightningOutput;
import eu.javaexperience.web.server.http.WellKnownSocketHttpProtocol;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class InternalHttpProtocol
extends AbstractHttpProtocolHandler {
    protected final PreparedURL requestUrl;
    protected final String method;
    protected final Map<String, String> requestHeaders;
    protected int returnStatus = 200;
    protected String returnStatusText = "OK";
    protected Map<String, String> returnHeaders;

    public InternalHttpProtocol(IOStream stream, URL url, String method, Map<String, String> headers) {
        super(stream, WellKnownSocketHttpProtocol.INTERNAL);
        this.requestUrl = new PreparedURL(url);
        this.method = method;
        AssertArgument.assertNotNull((Object)this.method, (String)"request method");
        this.requestHeaders = null == headers ? NullMap.instance : headers;
    }

    @Override
    public void sendResponseHeaders(LightningOutput os, int responseStatus, String responseStatusText, Map<String, String> send) throws IOException {
        this.returnStatus = responseStatus;
        this.returnStatusText = responseStatusText;
        this.returnHeaders = new SmallMap(send);
    }

    @Override
    public void finishTransmission(LightningOutput os) throws IOException {
    }

    @Override
    protected IOStream initSocketRequest() throws IOException {
        this.setParsedRequestProperties(this.requestUrl.getProtocol(), this.method, this.requestUrl.getDomainOnly(), String.valueOf(this.requestUrl.getPort()), this.requestUrl.getUri(), this.requestUrl.getUrl(), this.requestUrl.getQuery(), this.requestHeaders, this.requestUrl.getParams());
        return this.ioStream;
    }
}

