package eu.javaexperience.nativ.java;

import eu.javaexperience.gnu.GccTools;
import eu.javaexperience.nativ.posix.INTEGER;
import eu.javaexperience.nativ.posix.STRING;
import eu.javaexperience.nativ.posix.VOID;

public class JavaNativeExtension
{
	static
	{
		boolean loaded = GccTools.loadArchDependSharedJavaLibraryOrCompileAndLoad
		(
			"eu/javaexperience/nativ/java",
			"JavaNativeExtension",
			new String[]{"util", "dl"},
			null,
			new String[]{"-fpermissive"/*, "-Ofast"*/},
			System.out,
			System.err
		);
		
		if(!loaded)
			throw new UnsatisfiedLinkError("JavaNativeExtension shared library not found!");
		
		try
		{
			Class<?> c = null;
			c = STRING.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			c = INTEGER.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			c = VOID.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			//A nativ metódus már lássa ezeket az osztályokat,ezért hivatkozom rá.
		}
		catch(Throwable t)
		{
			throw new RuntimeException(t);
		}
		
		initNative();
	}
	
	protected native static void initNative();
	
	public static final native int udsClientConnect(String path);

	public static final native int udsServerListen(String path, int backlog, VOID struct_sockaddr_pointer, INTEGER address_len_pointer);
	
	/**
	 * The accept() function shall extract the first connection on the queue of pending connections, create a new socket with the same socket type protocol and address family as the specified socket, and allocate a new file descriptor for that socket.
	 * */
	public static final native int acceptBounded(int bounded_fd,INTEGER target_fd, long struct_sockaddr_pointer, int address_len_pointer);
	
	/**
	 * free with Posix.free(long);
	 * */
	public static native long newSockaddrUn(String path, INTEGER addrlen);
	
	/**
	 * free with Posix.free(long);
	 * */
	public static native long newSockaddrIn(String path, int port, INTEGER addrlen);

	@Deprecated
	public native static int read(int fd, byte[] b, int off, int len);
	
	@Deprecated
	public native static int write(int fd, byte[] b, int off, int len);
	
	public static int checkedRead(int fd, byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return read(fd, b, off, len);
	}
	
	public static int checkedWrite(int fd, byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return write(fd, b, off, len);
	}
	
	@Deprecated
	public native static int bufferedRead(int fd, long buffPtr, int bufflen, byte[] b, int off, int len);
	
	@Deprecated
	public native static int bufferedWrite(int fd, long buffPtr, int bufflen, byte[] b, int off, int len);
	
	public static int checkedBufferedRead(int fd, long buffPtr, int bufflen,  byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return bufferedRead(fd, buffPtr, bufflen, b, off, len);
	}
	
	public static int checkedBufferedWrite(int fd, long buffPtr, int bufflen, byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return bufferedWrite(fd, buffPtr, bufflen,  b, off, len);
	}
	
	public native static int accept(int fd, long addr, int len);
	
	public native static int initSocket(int fd);
	
	@Deprecated
	public native static int experimentalRead(int fd, byte[] b, int off, int len);
	
	@Deprecated
	public native static int experimentalWrite(int fd, byte[] b, int off, int len);
	
	public static int checkedExperimentalRead(int fd, byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return experimentalRead(fd, b, off, len);
	}
	
	public static int checkedExperimentalWrite(int fd, byte[] b, int off, int len)
	{
		int val = b[off]; 
		val = b[off+len-1];
		return experimentalWrite(fd, b, off, len);
	}
}
