package eu.javaexperience.nativ.posix;

import eu.javaexperience.asserts.AssertArgument;

public class CString
{
	protected final long ptr;
	protected final String str;
	public CString(String str)
	{
		AssertArgument.assertNotNull(this.str = str, "string");
		ptr = Posix.placeString(str);
	}
	
	public String getString()
	{
		return str;
	}
	
	public long getPointer()
	{
		return ptr;
	}
	
	protected void finalize()
	{
		Posix.free(ptr);
	}
}