package eu.javaexperience.unix.user;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;

import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.unix.user.exception.GroupDoesnotExistException;
import eu.javaexperience.unix.user.exception.UserDoesnotExistException;

public class UnixUser implements UnixUserEntity, Principal
{
	protected final String username;
	protected final int uid;
	
	public UnixUser(String username, int uid)
	{
		this.username = username;
		this.uid = uid;
	}
	
	@Override
	public String getName()
	{
		return username;
	}

	@Override
	public String getUsername()
	{
		return username;
	}

	@Override
	public int getUid()
	{
		return uid;
	}

	@Override
	public String getDefaultGroupname()
	{
		try
		{
			return UnixEntityManager.getUserDefaultGroupName(username);
		}
		catch(Exception e)
		{
			return null;
		}
	}

	@Override
	public int getDefaultGroupGid()
	{
		try
		{
			return UnixEntityManager.getUserDefaultGroupGid(username);
		}
		catch (Exception e)
		{
			return -1;
		}
	}

	@Override
	public UnixGroup getDefaultGroup()
	{
		try
		{
			return UnixGroup.getInstanceByName(UnixEntityManager.getUserDefaultGroupName(username));
		}
		catch (Exception e)
		{
			return null;
		}
	}

	@Override
	public UnixGroupEntity[] getUnixGroups() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String[] getUnixGroupNames()
	{
		try
		{
			return UnixEntityManager.getUserGroups(username);
		}
		catch (Exception e)
		{
			return Mirror.emptyStringArray;
		}
	}

	@Override
	public int[] getUnixGids() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String toString()
	{
		return "UnixUser: "+username;
	}

	public String getHomePath() throws UserDoesnotExistException, IOException
	{
		return UnixEntityManager.getUserHomePath(username);
	}

	public String getRealName() throws UserDoesnotExistException, IOException
	{
		return UnixEntityManager.getUserRealName(username);
	}
}
