package eu.javaexperience.commands;

import java.io.File;
import java.io.IOException;

import eu.javaexperience.arrays.ArrayTools;

public class LinuxCommandTools
{
	protected static boolean execZero(String... params) throws InterruptedException, IOException
	{
		return 0 == new ProcessBuilder(params).start().waitFor();
	}
	
	public static boolean chown(String file, String user, String group) throws InterruptedException, IOException
	{
		return execZero("chown", user+":"+group, file.toString());
	}
	
	public static boolean chown(String file, String user) throws InterruptedException, IOException
	{
		return execZero("chown", user, file.toString());
	}
	
	
	
	/**
	 * warn: specify permission as normal, 10 base number:
	 * int 777 for rwxrwxrwx (and not 0777)
	 * */
	public static boolean chmod(String file, int mode) throws InterruptedException, IOException
	{
		return execZero("chmod", String.valueOf(mode), file.toString());
	}

	public static boolean chmod(File file, int mode) throws InterruptedException, IOException
	{
		return chmod(file.toString(), mode);
	}
	
	public static boolean tarCompressDirectory(String destinationTarFile, String... directories) throws InterruptedException, IOException
	{
		return execZero(ArrayTools.arrayConcat(new String[]{"tar","cf", destinationTarFile }, directories));
	}
	
	public static boolean tarCompressDirectory(File destinationTarFile, String... directories) throws InterruptedException, IOException
	{
		return execZero(ArrayTools.arrayConcat(new String[]{"tar","cf", destinationTarFile.toString() }, directories));
	}
	
	
}
